/******************************************************************************
*                                                                             *
*  easycap_testcard.c                                                         *
*                                                                             *
******************************************************************************/
/*
 *
 *  Copyright (C) 2010 R.M. Thomas  <rmthomas@sciolus.org>
 *
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  The software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/
/*****************************************************************************/

#include "easycap.h"
#include "easycap_debug.h"

/*****************************************************************************/
#define TESTCARD_BYTESPERLINE (2 * 1440)
void
easycap_testcard(struct easycap *peasycap, int field_fill)
{
int total;
int y, u, v, r, g, b;
unsigned char uyvy[4];

int i1, line, k, m, n, more, much, barwidth;
unsigned char bfbar[TESTCARD_BYTESPERLINE / 8], *p1, *p2;
struct data_buffer *pfield_buffer;

JOT(8, "%i=field_fill\n", field_fill);

if ((TESTCARD_BYTESPERLINE / 2) < peasycap->width) {
	SAY("ERROR: image is too wide\n");
	return;
}
if (peasycap->width % 16) {
	SAY("ERROR: indivisible image width\n");
	return;
}

total = 0;
barwidth = (2 * peasycap->width) / 8;

k = field_fill;
m = 0;
n = 0;

for (line = 0;  line < (peasycap->height / 2);  line++) {
	for (i1 = 0;  i1 < 8;  i1++) {
		r = (i1 * 256)/8;
		g = (i1 * 256)/8;
		b = (i1 * 256)/8;

		y =  299*r/1000 + 587*g/1000 + 114*b/1000 ;
		u = -147*r/1000 - 289*g/1000 + 436*b/1000 ;  u = u + 128;
		v =  615*r/1000 - 515*g/1000 - 100*b/1000 ;  v = v + 128;

		uyvy[0] =  0xFF & u ;
		uyvy[1] =  0xFF & y ;
		uyvy[2] =  0xFF & v ;
		uyvy[3] =  0xFF & y ;

		p1 = &bfbar[0];
		while (p1 < &bfbar[barwidth]) {
			*p1++ = uyvy[0] ;
			*p1++ = uyvy[1] ;
			*p1++ = uyvy[2] ;
			*p1++ = uyvy[3] ;
			total += 4;
			}

		p1 = &bfbar[0];
		more = barwidth;

		while (more) {
			if ((FIELD_BUFFER_SIZE/PAGE_SIZE) <= m) {
				SAY("ERROR:  bad m reached\n");
				return;
			}
		if (PAGE_SIZE < n) {
			SAY("ERROR:  bad n reached\n"); return;
		}

		if (0 > more) {
			SAY("ERROR:  internal fault\n");
			return;
		}

		much = PAGE_SIZE - n;
		if (much > more)
			much = more;
		pfield_buffer = &peasycap->field_buffer[k][m];
		p2 = pfield_buffer->pgo + n;
		memcpy(p2, p1, much);

		p1 += much;
		n += much;
		more -= much;
		if (PAGE_SIZE == n) {
			m++;
			n = 0;
			}
		}
	}
}

JOT(8, "%i=total\n", total);
if (total != peasycap->width * peasycap->height)
	SAY("ERROR: wrong number of bytes written:  %i\n", total);
return;
}
/*****************************************************************************/
#if defined(EASYCAP_TESTTONE)
/*-----------------------------------------------------------------------------
THE tones[] ARRAY BELOW IS THE OUTPUT OF THIS PROGRAM,
COMPILED gcc -o prog -lm prog.c
- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#include <stdio.h>
#include <math.h>

int main(void);
int
main(void)
{
int i1, i2, last;
double d1, d2;

last = 1024 - 1;
d1 = 10.0*3.14159265/1024.0;
printf("int tones[2048] =\n{\n");
for (i1 = 0;  i1 <= last;  i1++)
	{
	d2 = ((double)i1) * d1;
	i2 = (int)(16384.0*sin(d2));

	if (last != i1)
		{
		printf("%6i, ", i2);  printf("%6i, ", i2);
		if (!((i1 + 1)%5)) printf("\n");
		}
	else
		{
		printf("%6i, ", i2);  printf("%6i\n};\n", i2);
		}
	}
return(0);
}
-----------------------------------------------------------------------------*/
int tones[2048] = {
     0,     0,   502,   502,  1004,  1004,  1505,  1505,  2005,  2005,
  2503,  2503,  2998,  2998,  3491,  3491,  3980,  3980,  4466,  4466,
  4948,  4948,  5424,  5424,  5896,  5896,  6362,  6362,  6822,  6822,
  7276,  7276,  7723,  7723,  8162,  8162,  8594,  8594,  9018,  9018,
  9434,  9434,  9840,  9840, 10237, 10237, 10625, 10625, 11002, 11002,
 11370, 11370, 11726, 11726, 12072, 12072, 12406, 12406, 12728, 12728,
 13038, 13038, 13337, 13337, 13622, 13622, 13895, 13895, 14155, 14155,
 14401, 14401, 14634, 14634, 14853, 14853, 15058, 15058, 15249, 15249,
 15426, 15426, 15588, 15588, 15735, 15735, 15868, 15868, 15985, 15985,
 16088, 16088, 16175, 16175, 16248, 16248, 16305, 16305, 16346, 16346,
 16372, 16372, 16383, 16383, 16379, 16379, 16359, 16359, 16323, 16323,
 16272, 16272, 16206, 16206, 16125, 16125, 16028, 16028, 15917, 15917,
 15790, 15790, 15649, 15649, 15492, 15492, 15322, 15322, 15136, 15136,
 14937, 14937, 14723, 14723, 14496, 14496, 14255, 14255, 14001, 14001,
 13733, 13733, 13452, 13452, 13159, 13159, 12854, 12854, 12536, 12536,
 12207, 12207, 11866, 11866, 11513, 11513, 11150, 11150, 10777, 10777,
 10393, 10393, 10000, 10000,  9597,  9597,  9185,  9185,  8765,  8765,
  8336,  8336,  7900,  7900,  7456,  7456,  7005,  7005,  6547,  6547,
  6083,  6083,  5614,  5614,  5139,  5139,  4659,  4659,  4175,  4175,
  3687,  3687,  3196,  3196,  2701,  2701,  2204,  2204,  1705,  1705,
  1205,  1205,   703,   703,   201,   201,  -301,  -301,  -803,  -803,
 -1305, -1305, -1805, -1805, -2304, -2304, -2801, -2801, -3294, -3294,
 -3785, -3785, -4272, -4272, -4756, -4756, -5234, -5234, -5708, -5708,
 -6176, -6176, -6639, -6639, -7095, -7095, -7545, -7545, -7988, -7988,
 -8423, -8423, -8850, -8850, -9268, -9268, -9679, -9679, -10079, -10079,
-10471, -10471, -10853, -10853, -11224, -11224, -11585, -11585, -11935, -11935,
-12273, -12273, -12600, -12600, -12916, -12916, -13219, -13219, -13510, -13510,
-13788, -13788, -14053, -14053, -14304, -14304, -14543, -14543, -14767, -14767,
-14978, -14978, -15175, -15175, -15357, -15357, -15525, -15525, -15678, -15678,
-15817, -15817, -15940, -15940, -16049, -16049, -16142, -16142, -16221, -16221,
-16284, -16284, -16331, -16331, -16364, -16364, -16381, -16381, -16382, -16382,
-16368, -16368, -16339, -16339, -16294, -16294, -16234, -16234, -16159, -16159,
-16069, -16069, -15963, -15963, -15842, -15842, -15707, -15707, -15557, -15557,
-15392, -15392, -15212, -15212, -15018, -15018, -14810, -14810, -14589, -14589,
-14353, -14353, -14104, -14104, -13842, -13842, -13566, -13566, -13278, -13278,
-12977, -12977, -12665, -12665, -12340, -12340, -12003, -12003, -11656, -11656,
-11297, -11297, -10928, -10928, -10548, -10548, -10159, -10159, -9759, -9759,
 -9351, -9351, -8934, -8934, -8509, -8509, -8075, -8075, -7634, -7634,
 -7186, -7186, -6731, -6731, -6269, -6269, -5802, -5802, -5329, -5329,
 -4852, -4852, -4369, -4369, -3883, -3883, -3393, -3393, -2900, -2900,
 -2404, -2404, -1905, -1905, -1405, -1405,  -904,  -904,  -402,  -402,
   100,   100,   603,   603,  1105,  1105,  1605,  1605,  2105,  2105,
  2602,  2602,  3097,  3097,  3589,  3589,  4078,  4078,  4563,  4563,
  5043,  5043,  5519,  5519,  5990,  5990,  6455,  6455,  6914,  6914,
  7366,  7366,  7811,  7811,  8249,  8249,  8680,  8680,  9102,  9102,
  9516,  9516,  9920,  9920, 10315, 10315, 10701, 10701, 11077, 11077,
 11442, 11442, 11796, 11796, 12139, 12139, 12471, 12471, 12791, 12791,
 13099, 13099, 13395, 13395, 13678, 13678, 13948, 13948, 14205, 14205,
 14449, 14449, 14679, 14679, 14895, 14895, 15098, 15098, 15286, 15286,
 15459, 15459, 15618, 15618, 15763, 15763, 15892, 15892, 16007, 16007,
 16107, 16107, 16191, 16191, 16260, 16260, 16314, 16314, 16353, 16353,
 16376, 16376, 16384, 16384, 16376, 16376, 16353, 16353, 16314, 16314,
 16260, 16260, 16191, 16191, 16107, 16107, 16007, 16007, 15892, 15892,
 15763, 15763, 15618, 15618, 15459, 15459, 15286, 15286, 15098, 15098,
 14895, 14895, 14679, 14679, 14449, 14449, 14205, 14205, 13948, 13948,
 13678, 13678, 13395, 13395, 13099, 13099, 12791, 12791, 12471, 12471,
 12139, 12139, 11796, 11796, 11442, 11442, 11077, 11077, 10701, 10701,
 10315, 10315,  9920,  9920,  9516,  9516,  9102,  9102,  8680,  8680,
  8249,  8249,  7811,  7811,  7366,  7366,  6914,  6914,  6455,  6455,
  5990,  5990,  5519,  5519,  5043,  5043,  4563,  4563,  4078,  4078,
  3589,  3589,  3097,  3097,  2602,  2602,  2105,  2105,  1605,  1605,
  1105,  1105,   603,   603,   100,   100,  -402,  -402,  -904,  -904,
 -1405, -1405, -1905, -1905, -2404, -2404, -2900, -2900, -3393, -3393,
 -3883, -3883, -4369, -4369, -4852, -4852, -5329, -5329, -5802, -5802,
 -6269, -6269, -6731, -6731, -7186, -7186, -7634, -7634, -8075, -8075,
 -8509, -8509, -8934, -8934, -9351, -9351, -9759, -9759, -10159, -10159,
-10548, -10548, -10928, -10928, -11297, -11297, -11656, -11656, -12003, -12003,
-12340, -12340, -12665, -12665, -12977, -12977, -13278, -13278, -13566, -13566,
-13842, -13842, -14104, -14104, -14353, -14353, -14589, -14589, -14810, -14810,
-15018, -15018, -15212, -15212, -15392, -15392, -15557, -15557, -15707, -15707,
-15842, -15842, -15963, -15963, -16069, -16069, -16159, -16159, -16234, -16234,
-16294, -16294, -16339, -16339, -16368, -16368, -16382, -16382, -16381, -16381,
-16364, -16364, -16331, -16331, -16284, -16284, -16221, -16221, -16142, -16142,
-16049, -16049, -15940, -15940, -15817, -15817, -15678, -15678, -15525, -15525,
-15357, -15357, -15175, -15175, -14978, -14978, -14767, -14767, -14543, -14543,
-14304, -14304, -14053, -14053, -13788, -13788, -13510, -13510, -13219, -13219,
-12916, -12916, -12600, -12600, -12273, -12273, -11935, -11935, -11585, -11585,
-11224, -11224, -10853, -10853, -10471, -10471, -10079, -10079, -9679, -9679,
 -9268, -9268, -8850, -8850, -8423, -8423, -7988, -7988, -7545, -7545,
 -7095, -7095, -6639, -6639, -6176, -6176, -5708, -5708, -5234, -5234,
 -4756, -4756, -4272, -4272, -3785, -3785, -3294, -3294, -2801, -2801,
 -2304, -2304, -1805, -1805, -1305, -1305,  -803,  -803,  -301,  -301,
   201,   201,   703,   703,  1205,  1205,  1705,  1705,  2204,  2204,
  2701,  2701,  3196,  3196,  3687,  3687,  4175,  4175,  4659,  4659,
  5139,  5139,  5614,  5614,  6083,  6083,  6547,  6547,  7005,  7005,
  7456,  7456,  7900,  7900,  8336,  8336,  8765,  8765,  9185,  9185,
  9597,  9597, 10000, 10000, 10393, 10393, 10777, 10777, 11150, 11150,
 11513, 11513, 11866, 11866, 12207, 12207, 12536, 12536, 12854, 12854,
 13159, 13159, 13452, 13452, 13733, 13733, 14001, 14001, 14255, 14255,
 14496, 14496, 14723, 14723, 14937, 14937, 15136, 15136, 15322, 15322,
 15492, 15492, 15649, 15649, 15790, 15790, 15917, 15917, 16028, 16028,
 16125, 16125, 16206, 16206, 16272, 16272, 16323, 16323, 16359, 16359,
 16379, 16379, 16383, 16383, 16372, 16372, 16346, 16346, 16305, 16305,
 16248, 16248, 16175, 16175, 16088, 16088, 15985, 15985, 15868, 15868,
 15735, 15735, 15588, 15588, 15426, 15426, 15249, 15249, 15058, 15058,
 14853, 14853, 14634, 14634, 14401, 14401, 14155, 14155, 13895, 13895,
 13622, 13622, 13337, 13337, 13038, 13038, 12728, 12728, 12406, 12406,
 12072, 12072, 11726, 11726, 11370, 11370, 11002, 11002, 10625, 10625,
 10237, 10237,  9840,  9840,  9434,  9434,  9018,  9018,  8594,  8594,
  8162,  8162,  7723,  7723,  7276,  7276,  6822,  6822,  6362,  6362,
  5896,  5896,  5424,  5424,  4948,  4948,  4466,  4466,  3980,  3980,
  3491,  3491,  2998,  2998,  2503,  2503,  2005,  2005,  1505,  1505,
  1004,  1004,   502,   502,     0,     0,  -502,  -502, -1004, -1004,
 -1505, -1505, -2005, -2005, -2503, -2503, -2998, -2998, -3491, -3491,
 -3980, -3980, -4466, -4466, -4948, -4948, -5424, -5424, -5896, -5896,
 -6362, -6362, -6822, -6822, -7276, -7276, -7723, -7723, -8162, -8162,
 -8594, -8594, -9018, -9018, -9434, -9434, -9840, -9840, -10237, -10237,
-10625, -10625, -11002, -11002, -11370, -11370, -11726, -11726, -12072, -12072,
-12406, -12406, -12728, -12728, -13038, -13038, -13337, -13337, -13622, -13622,
-13895, -13895, -14155, -14155, -14401, -14401, -14634, -14634, -14853, -14853,
-15058, -15058, -15249, -15249, -15426, -15426, -15588, -15588, -15735, -15735,
-15868, -15868, -15985, -15985, -16088, -16088, -16175, -16175, -16248, -16248,
-16305, -16305, -16346, -16346, -16372, -16372, -16383, -16383, -16379, -16379,
-16359, -16359, -16323, -16323, -16272, -16272, -16206, -16206, -16125, -16125,
-16028, -16028, -15917, -15917, -15790, -15790, -15649, -15649, -15492, -15492,
-15322, -15322, -15136, -15136, -14937, -14937, -14723, -14723, -14496, -14496,
-14255, -14255, -14001, -14001, -13733, -13733, -13452, -13452, -13159, -13159,
-12854, -12854, -12536, -12536, -12207, -12207, -11866, -11866, -11513, -11513,
-11150, -11150, -10777, -10777, -10393, -10393, -10000, -10000, -9597, -9597,
 -9185, -9185, -8765, -8765, -8336, -8336, -7900, -7900, -7456, -7456,
 -7005, -7005, -6547, -6547, -6083, -6083, -5614, -5614, -5139, -5139,
 -4659, -4659, -4175, -4175, -3687, -3687, -3196, -3196, -2701, -2701,
 -2204, -2204, -1705, -1705, -1205, -1205,  -703,  -703,  -201,  -201,
   301,   301,   803,   803,  1305,  1305,  1805,  1805,  2304,  2304,
  2801,  2801,  3294,  3294,  3785,  3785,  4272,  4272,  4756,  4756,
  5234,  5234,  5708,  5708,  6176,  6176,  6639,  6639,  7095,  7095,
  7545,  7545,  7988,  7988,  8423,  8423,  8850,  8850,  9268,  9268,
  9679,  9679, 10079, 10079, 10471, 10471, 10853, 10853, 11224, 11224,
 11585, 11585, 11935, 11935, 12273, 12273, 12600, 12600, 12916, 12916,
 13219, 13219, 13510, 13510, 13788, 13788, 14053, 14053, 14304, 14304,
 14543, 14543, 14767, 14767, 14978, 14978, 15175, 15175, 15357, 15357,
 15525, 15525, 15678, 15678, 15817, 15817, 15940, 15940, 16049, 16049,
 16142, 16142, 16221, 16221, 16284, 16284, 16331, 16331, 16364, 16364,
 16381, 16381, 16382, 16382, 16368, 16368, 16339, 16339, 16294, 16294,
 16234, 16234, 16159, 16159, 16069, 16069, 15963, 15963, 15842, 15842,
 15707, 15707, 15557, 15557, 15392, 15392, 15212, 15212, 15018, 15018,
 14810, 14810, 14589, 14589, 14353, 14353, 14104, 14104, 13842, 13842,
 13566, 13566, 13278, 13278, 12977, 12977, 12665, 12665, 12340, 12340,
 12003, 12003, 11656, 11656, 11297, 11297, 10928, 10928, 10548, 10548,
 10159, 10159,  9759,  9759,  9351,  9351,  8934,  8934,  8509,  8509,
  8075,  8075,  7634,  7634,  7186,  7186,  6731,  6731,  6269,  6269,
  5802,  5802,  5329,  5329,  4852,  4852,  4369,  4369,  3883,  3883,
  3393,  3393,  2900,  2900,  2404,  2404,  1905,  1905,  1405,  1405,
   904,   904,   402,   402,  -100,  -100,  -603,  -603, -1105, -1105,
 -1605, -1605, -2105, -2105, -2602, -2602, -3097, -3097, -3589, -3589,
 -4078, -4078, -4563, -4563, -5043, -5043, -5519, -5519, -5990, -5990,
 -6455, -6455, -6914, -6914, -7366, -7366, -7811, -7811, -8249, -8249,
 -8680, -8680, -9102, -9102, -9516, -9516, -9920, -9920, -10315, -10315,
-10701, -10701, -11077, -11077, -11442, -11442, -11796, -11796, -12139, -12139,
-12471, -12471, -12791, -12791, -13099, -13099, -13395, -13395, -13678, -13678,
-13948, -13948, -14205, -14205, -14449, -14449, -14679, -14679, -14895, -14895,
-15098, -15098, -15286, -15286, -15459, -15459, -15618, -15618, -15763, -15763,
-15892, -15892, -16007, -16007, -16107, -16107, -16191, -16191, -16260, -16260,
-16314, -16314, -16353, -16353, -16376, -16376, -16383, -16383, -16376, -16376,
-16353, -16353, -16314, -16314, -16260, -16260, -16191, -16191, -16107, -16107,
-16007, -16007, -15892, -15892, -15763, -15763, -15618, -15618, -15459, -15459,
-15286, -15286, -15098, -15098, -14895, -14895, -14679, -14679, -14449, -14449,
-14205, -14205, -13948, -13948, -13678, -13678, -13395, -13395, -13099, -13099,
-12791, -12791, -12471, -12471, -12139, -12139, -11796, -11796, -11442, -11442,
-11077, -11077, -10701, -10701, -10315, -10315, -9920, -9920, -9516, -9516,
 -9102, -9102, -8680, -8680, -8249, -8249, -7811, -7811, -7366, -7366,
 -6914, -6914, -6455, -6455, -5990, -5990, -5519, -5519, -5043, -5043,
 -4563, -4563, -4078, -4078, -3589, -3589, -3097, -3097, -2602, -2602,
 -2105, -2105, -1605, -1605, -1105, -1105,  -603,  -603,  -100,  -100,
   402,   402,   904,   904,  1405,  1405,  1905,  1905,  2404,  2404,
  2900,  2900,  3393,  3393,  3883,  3883,  4369,  4369,  4852,  4852,
  5329,  5329,  5802,  5802,  6269,  6269,  6731,  6731,  7186,  7186,
  7634,  7634,  8075,  8075,  8509,  8509,  8934,  8934,  9351,  9351,
  9759,  9759, 10159, 10159, 10548, 10548, 10928, 10928, 11297, 11297,
 11656, 11656, 12003, 12003, 12340, 12340, 12665, 12665, 12977, 12977,
 13278, 13278, 13566, 13566, 13842, 13842, 14104, 14104, 14353, 14353,
 14589, 14589, 14810, 14810, 15018, 15018, 15212, 15212, 15392, 15392,
 15557, 15557, 15707, 15707, 15842, 15842, 15963, 15963, 16069, 16069,
 16159, 16159, 16234, 16234, 16294, 16294, 16339, 16339, 16368, 16368,
 16382, 16382, 16381, 16381, 16364, 16364, 16331, 16331, 16284, 16284,
 16221, 16221, 16142, 16142, 16049, 16049, 15940, 15940, 15817, 15817,
 15678, 15678, 15525, 15525, 15357, 15357, 15175, 15175, 14978, 14978,
 14767, 14767, 14543, 14543, 14304, 14304, 14053, 14053, 13788, 13788,
 13510, 13510, 13219, 13219, 12916, 12916, 12600, 12600, 12273, 12273,
 11935, 11935, 11585, 11585, 11224, 11224, 10853, 10853, 10471, 10471,
 10079, 10079,  9679,  9679,  9268,  9268,  8850,  8850,  8423,  8423,
  7988,  7988,  7545,  7545,  7095,  7095,  6639,  6639,  6176,  6176,
  5708,  5708,  5234,  5234,  4756,  4756,  4272,  4272,  3785,  3785,
  3294,  3294,  2801,  2801,  2304,  2304,  1805,  1805,  1305,  1305,
   803,   803,   301,   301,  -201,  -201,  -703,  -703, -1205, -1205,
 -1705, -1705, -2204, -2204, -2701, -2701, -3196, -3196, -3687, -3687,
 -4175, -4175, -4659, -4659, -5139, -5139, -5614, -5614, -6083, -6083,
 -6547, -6547, -7005, -7005, -7456, -7456, -7900, -7900, -8336, -8336,
 -8765, -8765, -9185, -9185, -9597, -9597, -10000, -10000, -10393, -10393,
-10777, -10777, -11150, -11150, -11513, -11513, -11866, -11866, -12207, -12207,
-12536, -12536, -12854, -12854, -13159, -13159, -13452, -13452, -13733, -13733,
-14001, -14001, -14255, -14255, -14496, -14496, -14723, -14723, -14937, -14937,
-15136, -15136, -15322, -15322, -15492, -15492, -15649, -15649, -15790, -15790,
-15917, -15917, -16028, -16028, -16125, -16125, -16206, -16206, -16272, -16272,
-16323, -16323, -16359, -16359, -16379, -16379, -16383, -16383, -16372, -16372,
-16346, -16346, -16305, -16305, -16248, -16248, -16175, -16175, -16088, -16088,
-15985, -15985, -15868, -15868, -15735, -15735, -15588, -15588, -15426, -15426,
-15249, -15249, -15058, -15058, -14853, -14853, -14634, -14634, -14401, -14401,
-14155, -14155, -13895, -13895, -13622, -13622, -13337, -13337, -13038, -13038,
-12728, -12728, -12406, -12406, -12072, -12072, -11726, -11726, -11370, -11370,
-11002, -11002, -10625, -10625, -10237, -10237, -9840, -9840, -9434, -9434,
 -9018, -9018, -8594, -8594, -8162, -8162, -7723, -7723, -7276, -7276,
 -6822, -6822, -6362, -6362, -5896, -5896, -5424, -5424, -4948, -4948,
 -4466, -4466, -3980, -3980, -3491, -3491, -2998, -2998, -2503, -2503,
 -2005, -2005, -1505, -1505, -1004, -1004,  -502,  -502
};
/*****************************************************************************/
void
easysnd_testtone(struct easycap *peasycap, int audio_fill)
{
int i1;
unsigned char *p2;
struct data_buffer *paudio_buffer;

JOT(8, "%i=audio_fill\n", audio_fill);

paudio_buffer = &peasycap->audio_buffer[audio_fill];

p2 = (unsigned char *)(paudio_buffer->pgo);
for (i1 = 0;  i1 < PAGE_SIZE;  i1 += 4, p2 += 4) {
	*p2       = (unsigned char) (0x00FF & tones[i1/2]);
	*(p2 + 1) = (unsigned char)((0xFF00 & tones[i1/2]) >> 8);
	*(p2 + 2) = (unsigned char) (0x00FF & tones[i1/2 + 1]);
	*(p2 + 3) = (unsigned char)((0xFF00 & tones[i1/2 + 1]) >> 8);
	}
return;
}
#endif /*EASYCAP_TESTTONE*/
/*****************************************************************************/
