/*
 * Copyright (C) 2012-2017 ARM Limited or its affiliates.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __DX_HOST_H__
#define __DX_HOST_H__

// --------------------------------------
// BLOCK: HOST_P
// --------------------------------------
#define DX_HOST_IRR_REG_OFFSET 	0xA00UL 
#define DX_HOST_IRR_DSCRPTR_COMPLETION_LOW_INT_BIT_SHIFT 	0x2UL
#define DX_HOST_IRR_DSCRPTR_COMPLETION_LOW_INT_BIT_SIZE 	0x1UL
#define DX_HOST_IRR_AXI_ERR_INT_BIT_SHIFT 	0x8UL
#define DX_HOST_IRR_AXI_ERR_INT_BIT_SIZE 	0x1UL
#define DX_HOST_IRR_GPR0_BIT_SHIFT 	0xBUL
#define DX_HOST_IRR_GPR0_BIT_SIZE 	0x1UL
#define DX_HOST_IRR_DSCRPTR_WATERMARK_INT_BIT_SHIFT 	0x13UL
#define DX_HOST_IRR_DSCRPTR_WATERMARK_INT_BIT_SIZE 	0x1UL
#define DX_HOST_IRR_AXIM_COMP_INT_BIT_SHIFT 	0x17UL
#define DX_HOST_IRR_AXIM_COMP_INT_BIT_SIZE 	0x1UL
#define DX_HOST_IMR_REG_OFFSET 	0xA04UL 
#define DX_HOST_IMR_NOT_USED_MASK_BIT_SHIFT 	0x1UL
#define DX_HOST_IMR_NOT_USED_MASK_BIT_SIZE 	0x1UL
#define DX_HOST_IMR_DSCRPTR_COMPLETION_MASK_BIT_SHIFT 	0x2UL
#define DX_HOST_IMR_DSCRPTR_COMPLETION_MASK_BIT_SIZE 	0x1UL
#define DX_HOST_IMR_AXI_ERR_MASK_BIT_SHIFT 	0x8UL
#define DX_HOST_IMR_AXI_ERR_MASK_BIT_SIZE 	0x1UL
#define DX_HOST_IMR_GPR0_BIT_SHIFT 	0xBUL
#define DX_HOST_IMR_GPR0_BIT_SIZE 	0x1UL
#define DX_HOST_IMR_DSCRPTR_WATERMARK_MASK0_BIT_SHIFT 	0x13UL
#define DX_HOST_IMR_DSCRPTR_WATERMARK_MASK0_BIT_SIZE 	0x1UL
#define DX_HOST_IMR_AXIM_COMP_INT_MASK_BIT_SHIFT 	0x17UL
#define DX_HOST_IMR_AXIM_COMP_INT_MASK_BIT_SIZE 	0x1UL
#define DX_HOST_ICR_REG_OFFSET 	0xA08UL 
#define DX_HOST_ICR_DSCRPTR_COMPLETION_BIT_SHIFT 	0x2UL
#define DX_HOST_ICR_DSCRPTR_COMPLETION_BIT_SIZE 	0x1UL
#define DX_HOST_ICR_AXI_ERR_CLEAR_BIT_SHIFT 	0x8UL
#define DX_HOST_ICR_AXI_ERR_CLEAR_BIT_SIZE 	0x1UL
#define DX_HOST_ICR_GPR_INT_CLEAR_BIT_SHIFT 	0xBUL
#define DX_HOST_ICR_GPR_INT_CLEAR_BIT_SIZE 	0x1UL
#define DX_HOST_ICR_DSCRPTR_WATERMARK_QUEUE0_CLEAR_BIT_SHIFT 	0x13UL
#define DX_HOST_ICR_DSCRPTR_WATERMARK_QUEUE0_CLEAR_BIT_SIZE 	0x1UL
#define DX_HOST_ICR_AXIM_COMP_INT_CLEAR_BIT_SHIFT 	0x17UL
#define DX_HOST_ICR_AXIM_COMP_INT_CLEAR_BIT_SIZE 	0x1UL
#define DX_HOST_SIGNATURE_REG_OFFSET 	0xA24UL 
#define DX_HOST_SIGNATURE_VALUE_BIT_SHIFT 	0x0UL
#define DX_HOST_SIGNATURE_VALUE_BIT_SIZE 	0x20UL
#define DX_HOST_BOOT_REG_OFFSET 	0xA28UL 
#define DX_HOST_BOOT_SYNTHESIS_CONFIG_BIT_SHIFT 	0x0UL
#define DX_HOST_BOOT_SYNTHESIS_CONFIG_BIT_SIZE 	0x1UL
#define DX_HOST_BOOT_LARGE_RKEK_LOCAL_BIT_SHIFT 	0x1UL
#define DX_HOST_BOOT_LARGE_RKEK_LOCAL_BIT_SIZE 	0x1UL
#define DX_HOST_BOOT_HASH_IN_FUSES_LOCAL_BIT_SHIFT 	0x2UL
#define DX_HOST_BOOT_HASH_IN_FUSES_LOCAL_BIT_SIZE 	0x1UL
#define DX_HOST_BOOT_EXT_MEM_SECURED_LOCAL_BIT_SHIFT 	0x3UL
#define DX_HOST_BOOT_EXT_MEM_SECURED_LOCAL_BIT_SIZE 	0x1UL
#define DX_HOST_BOOT_RKEK_ECC_EXISTS_LOCAL_N_BIT_SHIFT 	0x5UL
#define DX_HOST_BOOT_RKEK_ECC_EXISTS_LOCAL_N_BIT_SIZE 	0x1UL
#define DX_HOST_BOOT_SRAM_SIZE_LOCAL_BIT_SHIFT 	0x6UL
#define DX_HOST_BOOT_SRAM_SIZE_LOCAL_BIT_SIZE 	0x3UL
#define DX_HOST_BOOT_DSCRPTR_EXISTS_LOCAL_BIT_SHIFT 	0x9UL
#define DX_HOST_BOOT_DSCRPTR_EXISTS_LOCAL_BIT_SIZE 	0x1UL
#define DX_HOST_BOOT_PAU_EXISTS_LOCAL_BIT_SHIFT 	0xAUL
#define DX_HOST_BOOT_PAU_EXISTS_LOCAL_BIT_SIZE 	0x1UL
#define DX_HOST_BOOT_RNG_EXISTS_LOCAL_BIT_SHIFT 	0xBUL
#define DX_HOST_BOOT_RNG_EXISTS_LOCAL_BIT_SIZE 	0x1UL
#define DX_HOST_BOOT_PKA_EXISTS_LOCAL_BIT_SHIFT 	0xCUL
#define DX_HOST_BOOT_PKA_EXISTS_LOCAL_BIT_SIZE 	0x1UL
#define DX_HOST_BOOT_RC4_EXISTS_LOCAL_BIT_SHIFT 	0xDUL
#define DX_HOST_BOOT_RC4_EXISTS_LOCAL_BIT_SIZE 	0x1UL
#define DX_HOST_BOOT_SHA_512_PRSNT_LOCAL_BIT_SHIFT 	0xEUL
#define DX_HOST_BOOT_SHA_512_PRSNT_LOCAL_BIT_SIZE 	0x1UL
#define DX_HOST_BOOT_SHA_256_PRSNT_LOCAL_BIT_SHIFT 	0xFUL
#define DX_HOST_BOOT_SHA_256_PRSNT_LOCAL_BIT_SIZE 	0x1UL
#define DX_HOST_BOOT_MD5_PRSNT_LOCAL_BIT_SHIFT 	0x10UL
#define DX_HOST_BOOT_MD5_PRSNT_LOCAL_BIT_SIZE 	0x1UL
#define DX_HOST_BOOT_HASH_EXISTS_LOCAL_BIT_SHIFT 	0x11UL
#define DX_HOST_BOOT_HASH_EXISTS_LOCAL_BIT_SIZE 	0x1UL
#define DX_HOST_BOOT_C2_EXISTS_LOCAL_BIT_SHIFT 	0x12UL
#define DX_HOST_BOOT_C2_EXISTS_LOCAL_BIT_SIZE 	0x1UL
#define DX_HOST_BOOT_DES_EXISTS_LOCAL_BIT_SHIFT 	0x13UL
#define DX_HOST_BOOT_DES_EXISTS_LOCAL_BIT_SIZE 	0x1UL
#define DX_HOST_BOOT_AES_XCBC_MAC_EXISTS_LOCAL_BIT_SHIFT 	0x14UL
#define DX_HOST_BOOT_AES_XCBC_MAC_EXISTS_LOCAL_BIT_SIZE 	0x1UL
#define DX_HOST_BOOT_AES_CMAC_EXISTS_LOCAL_BIT_SHIFT 	0x15UL
#define DX_HOST_BOOT_AES_CMAC_EXISTS_LOCAL_BIT_SIZE 	0x1UL
#define DX_HOST_BOOT_AES_CCM_EXISTS_LOCAL_BIT_SHIFT 	0x16UL
#define DX_HOST_BOOT_AES_CCM_EXISTS_LOCAL_BIT_SIZE 	0x1UL
#define DX_HOST_BOOT_AES_XEX_HW_T_CALC_LOCAL_BIT_SHIFT 	0x17UL
#define DX_HOST_BOOT_AES_XEX_HW_T_CALC_LOCAL_BIT_SIZE 	0x1UL
#define DX_HOST_BOOT_AES_XEX_EXISTS_LOCAL_BIT_SHIFT 	0x18UL
#define DX_HOST_BOOT_AES_XEX_EXISTS_LOCAL_BIT_SIZE 	0x1UL
#define DX_HOST_BOOT_CTR_EXISTS_LOCAL_BIT_SHIFT 	0x19UL
#define DX_HOST_BOOT_CTR_EXISTS_LOCAL_BIT_SIZE 	0x1UL
#define DX_HOST_BOOT_AES_DIN_BYTE_RESOLUTION_LOCAL_BIT_SHIFT 	0x1AUL
#define DX_HOST_BOOT_AES_DIN_BYTE_RESOLUTION_LOCAL_BIT_SIZE 	0x1UL
#define DX_HOST_BOOT_TUNNELING_ENB_LOCAL_BIT_SHIFT 	0x1BUL
#define DX_HOST_BOOT_TUNNELING_ENB_LOCAL_BIT_SIZE 	0x1UL
#define DX_HOST_BOOT_SUPPORT_256_192_KEY_LOCAL_BIT_SHIFT 	0x1CUL
#define DX_HOST_BOOT_SUPPORT_256_192_KEY_LOCAL_BIT_SIZE 	0x1UL
#define DX_HOST_BOOT_ONLY_ENCRYPT_LOCAL_BIT_SHIFT 	0x1DUL
#define DX_HOST_BOOT_ONLY_ENCRYPT_LOCAL_BIT_SIZE 	0x1UL
#define DX_HOST_BOOT_AES_EXISTS_LOCAL_BIT_SHIFT 	0x1EUL
#define DX_HOST_BOOT_AES_EXISTS_LOCAL_BIT_SIZE 	0x1UL
#define DX_HOST_VERSION_REG_OFFSET 	0xA40UL 
#define DX_HOST_VERSION_VALUE_BIT_SHIFT 	0x0UL
#define DX_HOST_VERSION_VALUE_BIT_SIZE 	0x20UL
#define DX_HOST_KFDE0_VALID_REG_OFFSET 	0xA60UL 
#define DX_HOST_KFDE0_VALID_VALUE_BIT_SHIFT 	0x0UL
#define DX_HOST_KFDE0_VALID_VALUE_BIT_SIZE 	0x1UL
#define DX_HOST_KFDE1_VALID_REG_OFFSET 	0xA64UL 
#define DX_HOST_KFDE1_VALID_VALUE_BIT_SHIFT 	0x0UL
#define DX_HOST_KFDE1_VALID_VALUE_BIT_SIZE 	0x1UL
#define DX_HOST_KFDE2_VALID_REG_OFFSET 	0xA68UL 
#define DX_HOST_KFDE2_VALID_VALUE_BIT_SHIFT 	0x0UL
#define DX_HOST_KFDE2_VALID_VALUE_BIT_SIZE 	0x1UL
#define DX_HOST_KFDE3_VALID_REG_OFFSET 	0xA6CUL 
#define DX_HOST_KFDE3_VALID_VALUE_BIT_SHIFT 	0x0UL
#define DX_HOST_KFDE3_VALID_VALUE_BIT_SIZE 	0x1UL
#define DX_HOST_GPR0_REG_OFFSET 	0xA70UL 
#define DX_HOST_GPR0_VALUE_BIT_SHIFT 	0x0UL
#define DX_HOST_GPR0_VALUE_BIT_SIZE 	0x20UL
#define DX_GPR_HOST_REG_OFFSET 	0xA74UL 
#define DX_GPR_HOST_VALUE_BIT_SHIFT 	0x0UL
#define DX_GPR_HOST_VALUE_BIT_SIZE 	0x20UL
#define DX_HOST_POWER_DOWN_EN_REG_OFFSET 	0xA78UL 
#define DX_HOST_POWER_DOWN_EN_VALUE_BIT_SHIFT 	0x0UL
#define DX_HOST_POWER_DOWN_EN_VALUE_BIT_SIZE 	0x1UL
// --------------------------------------
// BLOCK: HOST_SRAM
// --------------------------------------
#define DX_SRAM_DATA_REG_OFFSET 	0xF00UL 
#define DX_SRAM_DATA_VALUE_BIT_SHIFT 	0x0UL
#define DX_SRAM_DATA_VALUE_BIT_SIZE 	0x20UL
#define DX_SRAM_ADDR_REG_OFFSET 	0xF04UL 
#define DX_SRAM_ADDR_VALUE_BIT_SHIFT 	0x0UL
#define DX_SRAM_ADDR_VALUE_BIT_SIZE 	0xFUL
#define DX_SRAM_DATA_READY_REG_OFFSET 	0xF08UL 
#define DX_SRAM_DATA_READY_VALUE_BIT_SHIFT 	0x0UL
#define DX_SRAM_DATA_READY_VALUE_BIT_SIZE 	0x1UL

#endif //__DX_HOST_H__
