/*
 * SMU_7_1_2 Register documentation
 *
 * Copyright (C) 2014  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef SMU_7_1_2_D_H
#define SMU_7_1_2_D_H

#define mmGCK_SMC_IND_INDEX                                                     0x80
#define mmGCK0_GCK_SMC_IND_INDEX                                                0x80
#define mmGCK1_GCK_SMC_IND_INDEX                                                0x82
#define mmGCK2_GCK_SMC_IND_INDEX                                                0x84
#define mmGCK3_GCK_SMC_IND_INDEX                                                0x86
#define mmGCK_SMC_IND_DATA                                                      0x81
#define mmGCK0_GCK_SMC_IND_DATA                                                 0x81
#define mmGCK1_GCK_SMC_IND_DATA                                                 0x83
#define mmGCK2_GCK_SMC_IND_DATA                                                 0x85
#define mmGCK3_GCK_SMC_IND_DATA                                                 0x87
#define ixCG_DCLK_CNTL                                                          0xc050009c
#define ixCG_DCLK_STATUS                                                        0xc05000a0
#define ixCG_VCLK_CNTL                                                          0xc05000a4
#define ixCG_VCLK_STATUS                                                        0xc05000a8
#define ixCG_ECLK_CNTL                                                          0xc05000ac
#define ixCG_ECLK_STATUS                                                        0xc05000b0
#define ixCG_ACLK_CNTL                                                          0xc05000dc
#define ixGCK_DFS_BYPASS_CNTL                                                   0xc0500118
#define ixCG_SPLL_FUNC_CNTL                                                     0xc0500140
#define ixCG_SPLL_FUNC_CNTL_2                                                   0xc0500144
#define ixCG_SPLL_FUNC_CNTL_3                                                   0xc0500148
#define ixCG_SPLL_FUNC_CNTL_4                                                   0xc050014c
#define ixCG_SPLL_FUNC_CNTL_5                                                   0xc0500150
#define ixCG_SPLL_FUNC_CNTL_6                                                   0xc0500154
#define ixCG_SPLL_FUNC_CNTL_7                                                   0xc0500158
#define ixSPLL_CNTL_MODE                                                        0xc0500160
#define ixCG_SPLL_SPREAD_SPECTRUM                                               0xc0500164
#define ixCG_SPLL_SPREAD_SPECTRUM_2                                             0xc0500168
#define ixMPLL_BYPASSCLK_SEL                                                    0xc050019c
#define ixCG_CLKPIN_CNTL                                                        0xc05001a0
#define ixCG_CLKPIN_CNTL_2                                                      0xc05001a4
#define ixCG_CLKPIN_CNTL_DC                                                     0xc0500204
#define ixTHM_CLK_CNTL                                                          0xc05001a8
#define ixMISC_CLK_CTRL                                                         0xc05001ac
#define ixGCK_PLL_TEST_CNTL                                                     0xc05001c0
#define ixGCK_PLL_TEST_CNTL_2                                                   0xc05001c4
#define ixGCK_ADFS_CLK_BYPASS_CNTL1                                             0xc05001c8
#define mmSMC_IND_INDEX                                                         0x80
#define mmSMC0_SMC_IND_INDEX                                                    0x80
#define mmSMC1_SMC_IND_INDEX                                                    0x82
#define mmSMC2_SMC_IND_INDEX                                                    0x84
#define mmSMC3_SMC_IND_INDEX                                                    0x86
#define mmSMC_IND_DATA                                                          0x81
#define mmSMC0_SMC_IND_DATA                                                     0x81
#define mmSMC1_SMC_IND_DATA                                                     0x83
#define mmSMC2_SMC_IND_DATA                                                     0x85
#define mmSMC3_SMC_IND_DATA                                                     0x87
#define mmSMC_IND_INDEX_0                                                       0x80
#define mmSMC_IND_DATA_0                                                        0x81
#define mmSMC_IND_INDEX_1                                                       0x82
#define mmSMC_IND_DATA_1                                                        0x83
#define mmSMC_IND_INDEX_2                                                       0x84
#define mmSMC_IND_DATA_2                                                        0x85
#define mmSMC_IND_INDEX_3                                                       0x86
#define mmSMC_IND_DATA_3                                                        0x87
#define mmSMC_IND_INDEX_4                                                       0x88
#define mmSMC_IND_DATA_4                                                        0x89
#define mmSMC_IND_INDEX_5                                                       0x8a
#define mmSMC_IND_DATA_5                                                        0x8b
#define mmSMC_IND_INDEX_6                                                       0x8c
#define mmSMC_IND_DATA_6                                                        0x8d
#define mmSMC_IND_INDEX_7                                                       0x8e
#define mmSMC_IND_DATA_7                                                        0x8f
#define mmSMC_IND_ACCESS_CNTL                                                   0x92
#define mmSMC_MESSAGE_0                                                         0x94
#define mmSMC_RESP_0                                                            0x95
#define mmSMC_MESSAGE_1                                                         0x96
#define mmSMC_RESP_1                                                            0x97
#define mmSMC_MESSAGE_2                                                         0x98
#define mmSMC_RESP_2                                                            0x99
#define mmSMC_MESSAGE_3                                                         0x9a
#define mmSMC_RESP_3                                                            0x9b
#define mmSMC_MESSAGE_4                                                         0x9c
#define mmSMC_RESP_4                                                            0x9d
#define mmSMC_MESSAGE_5                                                         0x9e
#define mmSMC_RESP_5                                                            0x9f
#define mmSMC_MESSAGE_6                                                         0xa0
#define mmSMC_RESP_6                                                            0xa1
#define mmSMC_MESSAGE_7                                                         0xa2
#define mmSMC_RESP_7                                                            0xa3
#define mmSMC_MSG_ARG_0                                                         0xa4
#define mmSMC_MSG_ARG_1                                                         0xa5
#define mmSMC_MSG_ARG_2                                                         0xa6
#define mmSMC_MSG_ARG_3                                                         0xa7
#define mmSMC_MSG_ARG_4                                                         0xa8
#define mmSMC_MSG_ARG_5                                                         0xa9
#define mmSMC_MSG_ARG_6                                                         0xaa
#define mmSMC_MSG_ARG_7                                                         0xab
#define mmSMC_MESSAGE_8                                                         0xb5
#define mmSMC_RESP_8                                                            0xb6
#define mmSMC_MESSAGE_9                                                         0xb7
#define mmSMC_RESP_9                                                            0xb8
#define mmSMC_MESSAGE_10                                                        0xb9
#define mmSMC_RESP_10                                                           0xba
#define mmSMC_MESSAGE_11                                                        0xbb
#define mmSMC_RESP_11                                                           0xbc
#define mmSMC_MSG_ARG_8                                                         0xbd
#define mmSMC_MSG_ARG_9                                                         0xbe
#define mmSMC_MSG_ARG_10                                                        0xbf
#define mmSMC_MSG_ARG_11                                                        0x93
#define ixSMC_SYSCON_RESET_CNTL                                                 0x80000000
#define ixSMC_SYSCON_CLOCK_CNTL_0                                               0x80000004
#define ixSMC_SYSCON_CLOCK_CNTL_1                                               0x80000008
#define ixSMC_SYSCON_CLOCK_CNTL_2                                               0x8000000c
#define ixSMC_SYSCON_MISC_CNTL                                                  0x80000010
#define ixSMC_SYSCON_MSG_ARG_0                                                  0x80000068
#define ixSMC_PC_C                                                              0x80000370
#define ixSMC_SCRATCH9                                                          0x80000424
#define mmGPIOPAD_SW_INT_STAT                                                   0x180
#define mmGPIOPAD_STRENGTH                                                      0x181
#define mmGPIOPAD_MASK                                                          0x182
#define mmGPIOPAD_A                                                             0x183
#define mmGPIOPAD_EN                                                            0x184
#define mmGPIOPAD_Y                                                             0x185
#define mmGPIOPAD_PINSTRAPS                                                     0x186
#define mmGPIOPAD_INT_STAT_EN                                                   0x187
#define mmGPIOPAD_INT_STAT                                                      0x188
#define mmGPIOPAD_INT_STAT_AK                                                   0x189
#define mmGPIOPAD_INT_EN                                                        0x18a
#define mmGPIOPAD_INT_TYPE                                                      0x18b
#define mmGPIOPAD_INT_POLARITY                                                  0x18c
#define mmGPIOPAD_EXTERN_TRIG_CNTL                                              0x18d
#define mmGPIOPAD_RCVR_SEL                                                      0x191
#define mmGPIOPAD_PU_EN                                                         0x192
#define mmGPIOPAD_PD_EN                                                         0x193
#define mmCG_FPS_CNT                                                            0x1b6
#define mmSMU_IND_INDEX_0                                                       0x1a6
#define mmSMU_IND_DATA_0                                                        0x1a7
#define mmSMU_IND_INDEX_1                                                       0x1a8
#define mmSMU_IND_DATA_1                                                        0x1a9
#define mmSMU_IND_INDEX_2                                                       0x1aa
#define mmSMU_IND_DATA_2                                                        0x1ab
#define mmSMU_IND_INDEX_3                                                       0x1ac
#define mmSMU_IND_DATA_3                                                        0x1ad
#define mmSMU_IND_INDEX_4                                                       0x1ae
#define mmSMU_IND_DATA_4                                                        0x1af
#define mmSMU_IND_INDEX_5                                                       0x1b0
#define mmSMU_IND_DATA_5                                                        0x1b1
#define mmSMU_IND_INDEX_6                                                       0x1b2
#define mmSMU_IND_DATA_6                                                        0x1b3
#define mmSMU_IND_INDEX_7                                                       0x1b4
#define mmSMU_IND_DATA_7                                                        0x1b5
#define mmSMU_SMC_IND_INDEX                                                     0x80
#define mmSMU0_SMU_SMC_IND_INDEX                                                0x80
#define mmSMU1_SMU_SMC_IND_INDEX                                                0x82
#define mmSMU2_SMU_SMC_IND_INDEX                                                0x84
#define mmSMU3_SMU_SMC_IND_INDEX                                                0x86
#define mmSMU_SMC_IND_DATA                                                      0x81
#define mmSMU0_SMU_SMC_IND_DATA                                                 0x81
#define mmSMU1_SMU_SMC_IND_DATA                                                 0x83
#define mmSMU2_SMU_SMC_IND_DATA                                                 0x85
#define mmSMU3_SMU_SMC_IND_DATA                                                 0x87
#define ixRCU_UC_EVENTS                                                         0xc0000004
#define ixRCU_MISC_CTRL                                                         0xc0000010
#define ixRCU_VIRT_RESET_REQ                                                    0xc0000024
#define ixCC_RCU_FUSES                                                          0xc00c0000
#define ixCC_SMU_MISC_FUSES                                                     0xc00c0004
#define ixCC_SCLK_VID_FUSES                                                     0xc00c0008
#define ixCC_GIO_IOCCFG_FUSES                                                   0xc00c000c
#define ixCC_GIO_IOC_FUSES                                                      0xc00c0010
#define ixCC_SMU_TST_EFUSE1_MISC                                                0xc00c001c
#define ixCC_TST_ID_STRAPS                                                      0xc00c0020
#define ixCC_FCTRL_FUSES                                                        0xc00c0024
#define ixCC_HARVEST_FUSES                                                      0xc00c0028
#define ixSMU_MAIN_PLL_OP_FREQ                                                  0xe0003020
#define ixSMU_STATUS                                                            0xe0003088
#define ixSMU_FIRMWARE                                                          0xe00030a4
#define ixSMU_INPUT_DATA                                                        0xe00030b8
#define ixSMU_EFUSE_0                                                           0xc0100000
#define ixFIRMWARE_FLAGS                                                        0x3f800
#define ixTDC_STATUS                                                            0x3f804
#define ixTDC_MV_AVERAGE                                                        0x3f808
#define ixTDC_VRM_LIMIT                                                         0x3f80c
#define ixFEATURE_STATUS                                                        0x3f810
#define ixENTITY_TEMPERATURES_1                                                 0x3f814
#define ixDPM_TABLE_1                                                           0x3f000
#define ixDPM_TABLE_2                                                           0x3f004
#define ixDPM_TABLE_3                                                           0x3f008
#define ixDPM_TABLE_4                                                           0x3f00c
#define ixDPM_TABLE_5                                                           0x3f010
#define ixDPM_TABLE_6                                                           0x3f014
#define ixDPM_TABLE_7                                                           0x3f018
#define ixDPM_TABLE_8                                                           0x3f01c
#define ixDPM_TABLE_9                                                           0x3f020
#define ixDPM_TABLE_10                                                          0x3f024
#define ixDPM_TABLE_11                                                          0x3f028
#define ixDPM_TABLE_12                                                          0x3f02c
#define ixDPM_TABLE_13                                                          0x3f030
#define ixDPM_TABLE_14                                                          0x3f034
#define ixDPM_TABLE_15                                                          0x3f038
#define ixDPM_TABLE_16                                                          0x3f03c
#define ixDPM_TABLE_17                                                          0x3f040
#define ixDPM_TABLE_18                                                          0x3f044
#define ixDPM_TABLE_19                                                          0x3f048
#define ixDPM_TABLE_20                                                          0x3f04c
#define ixDPM_TABLE_21                                                          0x3f050
#define ixDPM_TABLE_22                                                          0x3f054
#define ixDPM_TABLE_23                                                          0x3f058
#define ixDPM_TABLE_24                                                          0x3f05c
#define ixDPM_TABLE_25                                                          0x3f060
#define ixDPM_TABLE_26                                                          0x3f064
#define ixDPM_TABLE_27                                                          0x3f068
#define ixDPM_TABLE_28                                                          0x3f06c
#define ixDPM_TABLE_29                                                          0x3f070
#define ixDPM_TABLE_30                                                          0x3f074
#define ixDPM_TABLE_31                                                          0x3f078
#define ixDPM_TABLE_32                                                          0x3f07c
#define ixDPM_TABLE_33                                                          0x3f080
#define ixDPM_TABLE_34                                                          0x3f084
#define ixDPM_TABLE_35                                                          0x3f088
#define ixDPM_TABLE_36                                                          0x3f08c
#define ixDPM_TABLE_37                                                          0x3f090
#define ixDPM_TABLE_38                                                          0x3f094
#define ixDPM_TABLE_39                                                          0x3f098
#define ixDPM_TABLE_40                                                          0x3f09c
#define ixDPM_TABLE_41                                                          0x3f0a0
#define ixDPM_TABLE_42                                                          0x3f0a4
#define ixDPM_TABLE_43                                                          0x3f0a8
#define ixDPM_TABLE_44                                                          0x3f0ac
#define ixDPM_TABLE_45                                                          0x3f0b0
#define ixDPM_TABLE_46                                                          0x3f0b4
#define ixDPM_TABLE_47                                                          0x3f0b8
#define ixDPM_TABLE_48                                                          0x3f0bc
#define ixDPM_TABLE_49                                                          0x3f0c0
#define ixDPM_TABLE_50                                                          0x3f0c4
#define ixDPM_TABLE_51                                                          0x3f0c8
#define ixDPM_TABLE_52                                                          0x3f0cc
#define ixDPM_TABLE_53                                                          0x3f0d0
#define ixDPM_TABLE_54                                                          0x3f0d4
#define ixDPM_TABLE_55                                                          0x3f0d8
#define ixDPM_TABLE_56                                                          0x3f0dc
#define ixDPM_TABLE_57                                                          0x3f0e0
#define ixDPM_TABLE_58                                                          0x3f0e4
#define ixDPM_TABLE_59                                                          0x3f0e8
#define ixDPM_TABLE_60                                                          0x3f0ec
#define ixDPM_TABLE_61                                                          0x3f0f0
#define ixDPM_TABLE_62                                                          0x3f0f4
#define ixDPM_TABLE_63                                                          0x3f0f8
#define ixDPM_TABLE_64                                                          0x3f0fc
#define ixDPM_TABLE_65                                                          0x3f100
#define ixDPM_TABLE_66                                                          0x3f104
#define ixDPM_TABLE_67                                                          0x3f108
#define ixDPM_TABLE_68                                                          0x3f10c
#define ixDPM_TABLE_69                                                          0x3f110
#define ixDPM_TABLE_70                                                          0x3f114
#define ixDPM_TABLE_71                                                          0x3f118
#define ixDPM_TABLE_72                                                          0x3f11c
#define ixDPM_TABLE_73                                                          0x3f120
#define ixDPM_TABLE_74                                                          0x3f124
#define ixDPM_TABLE_75                                                          0x3f128
#define ixDPM_TABLE_76                                                          0x3f12c
#define ixDPM_TABLE_77                                                          0x3f130
#define ixDPM_TABLE_78                                                          0x3f134
#define ixDPM_TABLE_79                                                          0x3f138
#define ixDPM_TABLE_80                                                          0x3f13c
#define ixDPM_TABLE_81                                                          0x3f140
#define ixDPM_TABLE_82                                                          0x3f144
#define ixDPM_TABLE_83                                                          0x3f148
#define ixDPM_TABLE_84                                                          0x3f14c
#define ixDPM_TABLE_85                                                          0x3f150
#define ixDPM_TABLE_86                                                          0x3f154
#define ixDPM_TABLE_87                                                          0x3f158
#define ixDPM_TABLE_88                                                          0x3f15c
#define ixDPM_TABLE_89                                                          0x3f160
#define ixDPM_TABLE_90                                                          0x3f164
#define ixDPM_TABLE_91                                                          0x3f168
#define ixDPM_TABLE_92                                                          0x3f16c
#define ixDPM_TABLE_93                                                          0x3f170
#define ixDPM_TABLE_94                                                          0x3f174
#define ixDPM_TABLE_95                                                          0x3f178
#define ixDPM_TABLE_96                                                          0x3f17c
#define ixDPM_TABLE_97                                                          0x3f180
#define ixDPM_TABLE_98                                                          0x3f184
#define ixDPM_TABLE_99                                                          0x3f188
#define ixDPM_TABLE_100                                                         0x3f18c
#define ixDPM_TABLE_101                                                         0x3f190
#define ixDPM_TABLE_102                                                         0x3f194
#define ixDPM_TABLE_103                                                         0x3f198
#define ixDPM_TABLE_104                                                         0x3f19c
#define ixDPM_TABLE_105                                                         0x3f1a0
#define ixDPM_TABLE_106                                                         0x3f1a4
#define ixDPM_TABLE_107                                                         0x3f1a8
#define ixDPM_TABLE_108                                                         0x3f1ac
#define ixDPM_TABLE_109                                                         0x3f1b0
#define ixDPM_TABLE_110                                                         0x3f1b4
#define ixDPM_TABLE_111                                                         0x3f1b8
#define ixDPM_TABLE_112                                                         0x3f1bc
#define ixDPM_TABLE_113                                                         0x3f1c0
#define ixDPM_TABLE_114                                                         0x3f1c4
#define ixDPM_TABLE_115                                                         0x3f1c8
#define ixDPM_TABLE_116                                                         0x3f1cc
#define ixDPM_TABLE_117                                                         0x3f1d0
#define ixDPM_TABLE_118                                                         0x3f1d4
#define ixDPM_TABLE_119                                                         0x3f1d8
#define ixDPM_TABLE_120                                                         0x3f1dc
#define ixDPM_TABLE_121                                                         0x3f1e0
#define ixDPM_TABLE_122                                                         0x3f1e4
#define ixDPM_TABLE_123                                                         0x3f1e8
#define ixDPM_TABLE_124                                                         0x3f1ec
#define ixDPM_TABLE_125                                                         0x3f1f0
#define ixDPM_TABLE_126                                                         0x3f1f4
#define ixDPM_TABLE_127                                                         0x3f1f8
#define ixDPM_TABLE_128                                                         0x3f1fc
#define ixDPM_TABLE_129                                                         0x3f200
#define ixDPM_TABLE_130                                                         0x3f204
#define ixDPM_TABLE_131                                                         0x3f208
#define ixDPM_TABLE_132                                                         0x3f20c
#define ixDPM_TABLE_133                                                         0x3f210
#define ixDPM_TABLE_134                                                         0x3f214
#define ixDPM_TABLE_135                                                         0x3f218
#define ixDPM_TABLE_136                                                         0x3f21c
#define ixDPM_TABLE_137                                                         0x3f220
#define ixDPM_TABLE_138                                                         0x3f224
#define ixDPM_TABLE_139                                                         0x3f228
#define ixDPM_TABLE_140                                                         0x3f22c
#define ixDPM_TABLE_141                                                         0x3f230
#define ixDPM_TABLE_142                                                         0x3f234
#define ixDPM_TABLE_143                                                         0x3f238
#define ixDPM_TABLE_144                                                         0x3f23c
#define ixDPM_TABLE_145                                                         0x3f240
#define ixDPM_TABLE_146                                                         0x3f244
#define ixDPM_TABLE_147                                                         0x3f248
#define ixDPM_TABLE_148                                                         0x3f24c
#define ixDPM_TABLE_149                                                         0x3f250
#define ixDPM_TABLE_150                                                         0x3f254
#define ixDPM_TABLE_151                                                         0x3f258
#define ixDPM_TABLE_152                                                         0x3f25c
#define ixDPM_TABLE_153                                                         0x3f260
#define ixDPM_TABLE_154                                                         0x3f264
#define ixDPM_TABLE_155                                                         0x3f268
#define ixDPM_TABLE_156                                                         0x3f26c
#define ixDPM_TABLE_157                                                         0x3f270
#define ixDPM_TABLE_158                                                         0x3f274
#define ixDPM_TABLE_159                                                         0x3f278
#define ixDPM_TABLE_160                                                         0x3f27c
#define ixDPM_TABLE_161                                                         0x3f280
#define ixDPM_TABLE_162                                                         0x3f284
#define ixDPM_TABLE_163                                                         0x3f288
#define ixDPM_TABLE_164                                                         0x3f28c
#define ixDPM_TABLE_165                                                         0x3f290
#define ixDPM_TABLE_166                                                         0x3f294
#define ixDPM_TABLE_167                                                         0x3f298
#define ixDPM_TABLE_168                                                         0x3f29c
#define ixDPM_TABLE_169                                                         0x3f2a0
#define ixDPM_TABLE_170                                                         0x3f2a4
#define ixDPM_TABLE_171                                                         0x3f2a8
#define ixDPM_TABLE_172                                                         0x3f2ac
#define ixDPM_TABLE_173                                                         0x3f2b0
#define ixDPM_TABLE_174                                                         0x3f2b4
#define ixDPM_TABLE_175                                                         0x3f2b8
#define ixDPM_TABLE_176                                                         0x3f2bc
#define ixDPM_TABLE_177                                                         0x3f2c0
#define ixDPM_TABLE_178                                                         0x3f2c4
#define ixDPM_TABLE_179                                                         0x3f2c8
#define ixDPM_TABLE_180                                                         0x3f2cc
#define ixDPM_TABLE_181                                                         0x3f2d0
#define ixDPM_TABLE_182                                                         0x3f2d4
#define ixDPM_TABLE_183                                                         0x3f2d8
#define ixDPM_TABLE_184                                                         0x3f2dc
#define ixDPM_TABLE_185                                                         0x3f2e0
#define ixDPM_TABLE_186                                                         0x3f2e4
#define ixDPM_TABLE_187                                                         0x3f2e8
#define ixDPM_TABLE_188                                                         0x3f2ec
#define ixDPM_TABLE_189                                                         0x3f2f0
#define ixDPM_TABLE_190                                                         0x3f2f4
#define ixDPM_TABLE_191                                                         0x3f2f8
#define ixDPM_TABLE_192                                                         0x3f2fc
#define ixDPM_TABLE_193                                                         0x3f300
#define ixDPM_TABLE_194                                                         0x3f304
#define ixDPM_TABLE_195                                                         0x3f308
#define ixDPM_TABLE_196                                                         0x3f30c
#define ixDPM_TABLE_197                                                         0x3f310
#define ixDPM_TABLE_198                                                         0x3f314
#define ixDPM_TABLE_199                                                         0x3f318
#define ixDPM_TABLE_200                                                         0x3f31c
#define ixDPM_TABLE_201                                                         0x3f320
#define ixDPM_TABLE_202                                                         0x3f324
#define ixDPM_TABLE_203                                                         0x3f328
#define ixDPM_TABLE_204                                                         0x3f32c
#define ixDPM_TABLE_205                                                         0x3f330
#define ixDPM_TABLE_206                                                         0x3f334
#define ixDPM_TABLE_207                                                         0x3f338
#define ixDPM_TABLE_208                                                         0x3f33c
#define ixDPM_TABLE_209                                                         0x3f340
#define ixDPM_TABLE_210                                                         0x3f344
#define ixDPM_TABLE_211                                                         0x3f348
#define ixDPM_TABLE_212                                                         0x3f34c
#define ixDPM_TABLE_213                                                         0x3f350
#define ixDPM_TABLE_214                                                         0x3f354
#define ixDPM_TABLE_215                                                         0x3f358
#define ixDPM_TABLE_216                                                         0x3f35c
#define ixDPM_TABLE_217                                                         0x3f360
#define ixDPM_TABLE_218                                                         0x3f364
#define ixDPM_TABLE_219                                                         0x3f368
#define ixDPM_TABLE_220                                                         0x3f36c
#define ixDPM_TABLE_221                                                         0x3f370
#define ixDPM_TABLE_222                                                         0x3f374
#define ixDPM_TABLE_223                                                         0x3f378
#define ixDPM_TABLE_224                                                         0x3f37c
#define ixDPM_TABLE_225                                                         0x3f380
#define ixDPM_TABLE_226                                                         0x3f384
#define ixDPM_TABLE_227                                                         0x3f388
#define ixDPM_TABLE_228                                                         0x3f38c
#define ixDPM_TABLE_229                                                         0x3f390
#define ixDPM_TABLE_230                                                         0x3f394
#define ixDPM_TABLE_231                                                         0x3f398
#define ixDPM_TABLE_232                                                         0x3f39c
#define ixDPM_TABLE_233                                                         0x3f3a0
#define ixDPM_TABLE_234                                                         0x3f3a4
#define ixDPM_TABLE_235                                                         0x3f3a8
#define ixDPM_TABLE_236                                                         0x3f3ac
#define ixDPM_TABLE_237                                                         0x3f3b0
#define ixDPM_TABLE_238                                                         0x3f3b4
#define ixDPM_TABLE_239                                                         0x3f3b8
#define ixDPM_TABLE_240                                                         0x3f3bc
#define ixDPM_TABLE_241                                                         0x3f3c0
#define ixDPM_TABLE_242                                                         0x3f3c4
#define ixDPM_TABLE_243                                                         0x3f3c8
#define ixDPM_TABLE_244                                                         0x3f3cc
#define ixDPM_TABLE_245                                                         0x3f3d0
#define ixDPM_TABLE_246                                                         0x3f3d4
#define ixDPM_TABLE_247                                                         0x3f3d8
#define ixDPM_TABLE_248                                                         0x3f3dc
#define ixDPM_TABLE_249                                                         0x3f3e0
#define ixDPM_TABLE_250                                                         0x3f3e4
#define ixDPM_TABLE_251                                                         0x3f3e8
#define ixDPM_TABLE_252                                                         0x3f3ec
#define ixDPM_TABLE_253                                                         0x3f3f0
#define ixDPM_TABLE_254                                                         0x3f3f4
#define ixDPM_TABLE_255                                                         0x3f3f8
#define ixDPM_TABLE_256                                                         0x3f3fc
#define ixDPM_TABLE_257                                                         0x3f400
#define ixDPM_TABLE_258                                                         0x3f404
#define ixDPM_TABLE_259                                                         0x3f408
#define ixDPM_TABLE_260                                                         0x3f40c
#define ixDPM_TABLE_261                                                         0x3f410
#define ixDPM_TABLE_262                                                         0x3f414
#define ixDPM_TABLE_263                                                         0x3f418
#define ixDPM_TABLE_264                                                         0x3f41c
#define ixDPM_TABLE_265                                                         0x3f420
#define ixDPM_TABLE_266                                                         0x3f424
#define ixDPM_TABLE_267                                                         0x3f428
#define ixDPM_TABLE_268                                                         0x3f42c
#define ixDPM_TABLE_269                                                         0x3f430
#define ixDPM_TABLE_270                                                         0x3f434
#define ixDPM_TABLE_271                                                         0x3f438
#define ixDPM_TABLE_272                                                         0x3f43c
#define ixDPM_TABLE_273                                                         0x3f440
#define ixDPM_TABLE_274                                                         0x3f444
#define ixDPM_TABLE_275                                                         0x3f448
#define ixDPM_TABLE_276                                                         0x3f44c
#define ixDPM_TABLE_277                                                         0x3f450
#define ixDPM_TABLE_278                                                         0x3f454
#define ixDPM_TABLE_279                                                         0x3f458
#define ixDPM_TABLE_280                                                         0x3f45c
#define ixDPM_TABLE_281                                                         0x3f460
#define ixDPM_TABLE_282                                                         0x3f464
#define ixDPM_TABLE_283                                                         0x3f468
#define ixDPM_TABLE_284                                                         0x3f46c
#define ixDPM_TABLE_285                                                         0x3f470
#define ixDPM_TABLE_286                                                         0x3f474
#define ixDPM_TABLE_287                                                         0x3f478
#define ixDPM_TABLE_288                                                         0x3f47c
#define ixDPM_TABLE_289                                                         0x3f480
#define ixDPM_TABLE_290                                                         0x3f484
#define ixDPM_TABLE_291                                                         0x3f488
#define ixDPM_TABLE_292                                                         0x3f48c
#define ixDPM_TABLE_293                                                         0x3f490
#define ixDPM_TABLE_294                                                         0x3f494
#define ixDPM_TABLE_295                                                         0x3f498
#define ixDPM_TABLE_296                                                         0x3f49c
#define ixDPM_TABLE_297                                                         0x3f4a0
#define ixDPM_TABLE_298                                                         0x3f4a4
#define ixDPM_TABLE_299                                                         0x3f4a8
#define ixDPM_TABLE_300                                                         0x3f4ac
#define ixDPM_TABLE_301                                                         0x3f4b0
#define ixDPM_TABLE_302                                                         0x3f4b4
#define ixDPM_TABLE_303                                                         0x3f4b8
#define ixDPM_TABLE_304                                                         0x3f4bc
#define ixDPM_TABLE_305                                                         0x3f4c0
#define ixDPM_TABLE_306                                                         0x3f4c4
#define ixDPM_TABLE_307                                                         0x3f4c8
#define ixDPM_TABLE_308                                                         0x3f4cc
#define ixDPM_TABLE_309                                                         0x3f4d0
#define ixDPM_TABLE_310                                                         0x3f4d4
#define ixDPM_TABLE_311                                                         0x3f4d8
#define ixDPM_TABLE_312                                                         0x3f4dc
#define ixDPM_TABLE_313                                                         0x3f4e0
#define ixDPM_TABLE_314                                                         0x3f4e4
#define ixDPM_TABLE_315                                                         0x3f4e8
#define ixDPM_TABLE_316                                                         0x3f4ec
#define ixDPM_TABLE_317                                                         0x3f4f0
#define ixDPM_TABLE_318                                                         0x3f4f4
#define ixDPM_TABLE_319                                                         0x3f4f8
#define ixDPM_TABLE_320                                                         0x3f4fc
#define ixDPM_TABLE_321                                                         0x3f500
#define ixDPM_TABLE_322                                                         0x3f504
#define ixDPM_TABLE_323                                                         0x3f508
#define ixDPM_TABLE_324                                                         0x3f50c
#define ixDPM_TABLE_325                                                         0x3f510
#define ixDPM_TABLE_326                                                         0x3f514
#define ixDPM_TABLE_327                                                         0x3f518
#define ixDPM_TABLE_328                                                         0x3f51c
#define ixDPM_TABLE_329                                                         0x3f520
#define ixDPM_TABLE_330                                                         0x3f524
#define ixDPM_TABLE_331                                                         0x3f528
#define ixDPM_TABLE_332                                                         0x3f52c
#define ixDPM_TABLE_333                                                         0x3f530
#define ixDPM_TABLE_334                                                         0x3f534
#define ixDPM_TABLE_335                                                         0x3f538
#define ixDPM_TABLE_336                                                         0x3f53c
#define ixDPM_TABLE_337                                                         0x3f540
#define ixDPM_TABLE_338                                                         0x3f544
#define ixDPM_TABLE_339                                                         0x3f548
#define ixDPM_TABLE_340                                                         0x3f54c
#define ixDPM_TABLE_341                                                         0x3f550
#define ixDPM_TABLE_342                                                         0x3f554
#define ixDPM_TABLE_343                                                         0x3f558
#define ixDPM_TABLE_344                                                         0x3f55c
#define ixDPM_TABLE_345                                                         0x3f560
#define ixDPM_TABLE_346                                                         0x3f564
#define ixDPM_TABLE_347                                                         0x3f568
#define ixDPM_TABLE_348                                                         0x3f56c
#define ixDPM_TABLE_349                                                         0x3f570
#define ixDPM_TABLE_350                                                         0x3f574
#define ixDPM_TABLE_351                                                         0x3f578
#define ixDPM_TABLE_352                                                         0x3f57c
#define ixDPM_TABLE_353                                                         0x3f580
#define ixDPM_TABLE_354                                                         0x3f584
#define ixDPM_TABLE_355                                                         0x3f588
#define ixDPM_TABLE_356                                                         0x3f58c
#define ixDPM_TABLE_357                                                         0x3f590
#define ixDPM_TABLE_358                                                         0x3f594
#define ixDPM_TABLE_359                                                         0x3f598
#define ixDPM_TABLE_360                                                         0x3f59c
#define ixDPM_TABLE_361                                                         0x3f5a0
#define ixDPM_TABLE_362                                                         0x3f5a4
#define ixDPM_TABLE_363                                                         0x3f5a8
#define ixDPM_TABLE_364                                                         0x3f5ac
#define ixDPM_TABLE_365                                                         0x3f5b0
#define ixDPM_TABLE_366                                                         0x3f5b4
#define ixDPM_TABLE_367                                                         0x3f5b8
#define ixDPM_TABLE_368                                                         0x3f5bc
#define ixDPM_TABLE_369                                                         0x3f5c0
#define ixDPM_TABLE_370                                                         0x3f5c4
#define ixDPM_TABLE_371                                                         0x3f5c8
#define ixDPM_TABLE_372                                                         0x3f5cc
#define ixDPM_TABLE_373                                                         0x3f5d0
#define ixDPM_TABLE_374                                                         0x3f5d4
#define ixDPM_TABLE_375                                                         0x3f5d8
#define ixDPM_TABLE_376                                                         0x3f5dc
#define ixDPM_TABLE_377                                                         0x3f5e0
#define ixDPM_TABLE_378                                                         0x3f5e4
#define ixDPM_TABLE_379                                                         0x3f5e8
#define ixDPM_TABLE_380                                                         0x3f5ec
#define ixDPM_TABLE_381                                                         0x3f5f0
#define ixDPM_TABLE_382                                                         0x3f5f4
#define ixDPM_TABLE_383                                                         0x3f5f8
#define ixDPM_TABLE_384                                                         0x3f5fc
#define ixDPM_TABLE_385                                                         0x3f600
#define ixDPM_TABLE_386                                                         0x3f604
#define ixDPM_TABLE_387                                                         0x3f608
#define ixDPM_TABLE_388                                                         0x3f60c
#define ixDPM_TABLE_389                                                         0x3f610
#define ixDPM_TABLE_390                                                         0x3f614
#define ixDPM_TABLE_391                                                         0x3f618
#define ixDPM_TABLE_392                                                         0x3f61c
#define ixDPM_TABLE_393                                                         0x3f620
#define ixDPM_TABLE_394                                                         0x3f624
#define ixDPM_TABLE_395                                                         0x3f628
#define ixDPM_TABLE_396                                                         0x3f62c
#define ixDPM_TABLE_397                                                         0x3f630
#define ixDPM_TABLE_398                                                         0x3f634
#define ixDPM_TABLE_399                                                         0x3f638
#define ixDPM_TABLE_400                                                         0x3f63c
#define ixDPM_TABLE_401                                                         0x3f640
#define ixDPM_TABLE_402                                                         0x3f644
#define ixDPM_TABLE_403                                                         0x3f648
#define ixDPM_TABLE_404                                                         0x3f64c
#define ixDPM_TABLE_405                                                         0x3f650
#define ixDPM_TABLE_406                                                         0x3f654
#define ixDPM_TABLE_407                                                         0x3f658
#define ixDPM_TABLE_408                                                         0x3f65c
#define ixDPM_TABLE_409                                                         0x3f660
#define ixDPM_TABLE_410                                                         0x3f664
#define ixDPM_TABLE_411                                                         0x3f668
#define ixDPM_TABLE_412                                                         0x3f66c
#define ixDPM_TABLE_413                                                         0x3f670
#define ixDPM_TABLE_414                                                         0x3f674
#define ixDPM_TABLE_415                                                         0x3f678
#define ixDPM_TABLE_416                                                         0x3f67c
#define ixDPM_TABLE_417                                                         0x3f680
#define ixDPM_TABLE_418                                                         0x3f684
#define ixDPM_TABLE_419                                                         0x3f688
#define ixDPM_TABLE_420                                                         0x3f68c
#define ixDPM_TABLE_421                                                         0x3f690
#define ixDPM_TABLE_422                                                         0x3f694
#define ixDPM_TABLE_423                                                         0x3f698
#define ixDPM_TABLE_424                                                         0x3f69c
#define ixDPM_TABLE_425                                                         0x3f6a0
#define ixDPM_TABLE_426                                                         0x3f6a4
#define ixDPM_TABLE_427                                                         0x3f6a8
#define ixDPM_TABLE_428                                                         0x3f6ac
#define ixDPM_TABLE_429                                                         0x3f6b0
#define ixDPM_TABLE_430                                                         0x3f6b4
#define ixDPM_TABLE_431                                                         0x3f6b8
#define ixDPM_TABLE_432                                                         0x3f6bc
#define ixDPM_TABLE_433                                                         0x3f6c0
#define ixDPM_TABLE_434                                                         0x3f6c4
#define ixDPM_TABLE_435                                                         0x3f6c8
#define ixDPM_TABLE_436                                                         0x3f6cc
#define ixDPM_TABLE_437                                                         0x3f6d0
#define ixDPM_TABLE_438                                                         0x3f6d4
#define ixDPM_TABLE_439                                                         0x3f6d8
#define ixDPM_TABLE_440                                                         0x3f6dc
#define ixDPM_TABLE_441                                                         0x3f6e0
#define ixDPM_TABLE_442                                                         0x3f6e4
#define ixDPM_TABLE_443                                                         0x3f6e8
#define ixDPM_TABLE_444                                                         0x3f6ec
#define ixDPM_TABLE_445                                                         0x3f6f0
#define ixDPM_TABLE_446                                                         0x3f6f4
#define ixDPM_TABLE_447                                                         0x3f6f8
#define ixDPM_TABLE_448                                                         0x3f6fc
#define ixDPM_TABLE_449                                                         0x3f700
#define ixDPM_TABLE_450                                                         0x3f704
#define ixDPM_TABLE_451                                                         0x3f708
#define ixDPM_TABLE_452                                                         0x3f70c
#define ixDPM_TABLE_453                                                         0x3f710
#define ixDPM_TABLE_454                                                         0x3f714
#define ixDPM_TABLE_455                                                         0x3f718
#define ixDPM_TABLE_456                                                         0x3f71c
#define ixDPM_TABLE_457                                                         0x3f720
#define ixDPM_TABLE_458                                                         0x3f724
#define ixDPM_TABLE_459                                                         0x3f728
#define ixDPM_TABLE_460                                                         0x3f72c
#define ixDPM_TABLE_461                                                         0x3f730
#define ixDPM_TABLE_462                                                         0x3f734
#define ixDPM_TABLE_463                                                         0x3f738
#define ixDPM_TABLE_464                                                         0x3f73c
#define ixDPM_TABLE_465                                                         0x3f740
#define ixDPM_TABLE_466                                                         0x3f744
#define ixDPM_TABLE_467                                                         0x3f748
#define ixDPM_TABLE_468                                                         0x3f74c
#define ixDPM_TABLE_469                                                         0x3f750
#define ixDPM_TABLE_470                                                         0x3f754
#define ixDPM_TABLE_471                                                         0x3f758
#define ixDPM_TABLE_472                                                         0x3f75c
#define ixDPM_TABLE_473                                                         0x3f760
#define ixDPM_TABLE_474                                                         0x3f764
#define ixDPM_TABLE_475                                                         0x3f768
#define ixDPM_TABLE_476                                                         0x3f76c
#define ixDPM_TABLE_477                                                         0x3f770
#define ixDPM_TABLE_478                                                         0x3f774
#define ixDPM_TABLE_479                                                         0x3f778
#define ixDPM_TABLE_480                                                         0x3f77c
#define ixDPM_TABLE_481                                                         0x3f780
#define ixDPM_TABLE_482                                                         0x3f784
#define ixDPM_TABLE_483                                                         0x3f788
#define ixDPM_TABLE_484                                                         0x3f78c
#define ixDPM_TABLE_485                                                         0x3f790
#define ixDPM_TABLE_486                                                         0x3f794
#define ixDPM_TABLE_487                                                         0x3f798
#define ixDPM_TABLE_488                                                         0x3f79c
#define ixDPM_TABLE_489                                                         0x3f7a0
#define ixDPM_TABLE_490                                                         0x3f7a4
#define ixMCARB_DRAM_TIMING_TABLE_1                                             0x3f900
#define ixMCARB_DRAM_TIMING_TABLE_2                                             0x3f904
#define ixMCARB_DRAM_TIMING_TABLE_3                                             0x3f908
#define ixMCARB_DRAM_TIMING_TABLE_4                                             0x3f90c
#define ixMCARB_DRAM_TIMING_TABLE_5                                             0x3f910
#define ixMCARB_DRAM_TIMING_TABLE_6                                             0x3f914
#define ixMCARB_DRAM_TIMING_TABLE_7                                             0x3f918
#define ixMCARB_DRAM_TIMING_TABLE_8                                             0x3f91c
#define ixMCARB_DRAM_TIMING_TABLE_9                                             0x3f920
#define ixMCARB_DRAM_TIMING_TABLE_10                                            0x3f924
#define ixMCARB_DRAM_TIMING_TABLE_11                                            0x3f928
#define ixMCARB_DRAM_TIMING_TABLE_12                                            0x3f92c
#define ixMCARB_DRAM_TIMING_TABLE_13                                            0x3f930
#define ixMCARB_DRAM_TIMING_TABLE_14                                            0x3f934
#define ixMCARB_DRAM_TIMING_TABLE_15                                            0x3f938
#define ixMCARB_DRAM_TIMING_TABLE_16                                            0x3f93c
#define ixMCARB_DRAM_TIMING_TABLE_17                                            0x3f940
#define ixMCARB_DRAM_TIMING_TABLE_18                                            0x3f944
#define ixMCARB_DRAM_TIMING_TABLE_19                                            0x3f948
#define ixMCARB_DRAM_TIMING_TABLE_20                                            0x3f94c
#define ixMCARB_DRAM_TIMING_TABLE_21                                            0x3f950
#define ixMCARB_DRAM_TIMING_TABLE_22                                            0x3f954
#define ixMCARB_DRAM_TIMING_TABLE_23                                            0x3f958
#define ixMCARB_DRAM_TIMING_TABLE_24                                            0x3f95c
#define ixMCARB_DRAM_TIMING_TABLE_25                                            0x3f960
#define ixMCARB_DRAM_TIMING_TABLE_26                                            0x3f964
#define ixMCARB_DRAM_TIMING_TABLE_27                                            0x3f968
#define ixMCARB_DRAM_TIMING_TABLE_28                                            0x3f96c
#define ixMCARB_DRAM_TIMING_TABLE_29                                            0x3f970
#define ixMCARB_DRAM_TIMING_TABLE_30                                            0x3f974
#define ixMCARB_DRAM_TIMING_TABLE_31                                            0x3f978
#define ixMCARB_DRAM_TIMING_TABLE_32                                            0x3f97c
#define ixMCARB_DRAM_TIMING_TABLE_33                                            0x3f980
#define ixMCARB_DRAM_TIMING_TABLE_34                                            0x3f984
#define ixMCARB_DRAM_TIMING_TABLE_35                                            0x3f988
#define ixMCARB_DRAM_TIMING_TABLE_36                                            0x3f98c
#define ixMCARB_DRAM_TIMING_TABLE_37                                            0x3f990
#define ixMCARB_DRAM_TIMING_TABLE_38                                            0x3f994
#define ixMCARB_DRAM_TIMING_TABLE_39                                            0x3f998
#define ixMCARB_DRAM_TIMING_TABLE_40                                            0x3f99c
#define ixMCARB_DRAM_TIMING_TABLE_41                                            0x3f9a0
#define ixMCARB_DRAM_TIMING_TABLE_42                                            0x3f9a4
#define ixMCARB_DRAM_TIMING_TABLE_43                                            0x3f9a8
#define ixMCARB_DRAM_TIMING_TABLE_44                                            0x3f9ac
#define ixMCARB_DRAM_TIMING_TABLE_45                                            0x3f9b0
#define ixMCARB_DRAM_TIMING_TABLE_46                                            0x3f9b4
#define ixMCARB_DRAM_TIMING_TABLE_47                                            0x3f9b8
#define ixMCARB_DRAM_TIMING_TABLE_48                                            0x3f9bc
#define ixMCARB_DRAM_TIMING_TABLE_49                                            0x3f9c0
#define ixMCARB_DRAM_TIMING_TABLE_50                                            0x3f9c4
#define ixMCARB_DRAM_TIMING_TABLE_51                                            0x3f9c8
#define ixMCARB_DRAM_TIMING_TABLE_52                                            0x3f9cc
#define ixMCARB_DRAM_TIMING_TABLE_53                                            0x3f9d0
#define ixMCARB_DRAM_TIMING_TABLE_54                                            0x3f9d4
#define ixMCARB_DRAM_TIMING_TABLE_55                                            0x3f9d8
#define ixMCARB_DRAM_TIMING_TABLE_56                                            0x3f9dc
#define ixMCARB_DRAM_TIMING_TABLE_57                                            0x3f9e0
#define ixMCARB_DRAM_TIMING_TABLE_58                                            0x3f9e4
#define ixMCARB_DRAM_TIMING_TABLE_59                                            0x3f9e8
#define ixMCARB_DRAM_TIMING_TABLE_60                                            0x3f9ec
#define ixMCARB_DRAM_TIMING_TABLE_61                                            0x3f9f0
#define ixMCARB_DRAM_TIMING_TABLE_62                                            0x3f9f4
#define ixMCARB_DRAM_TIMING_TABLE_63                                            0x3f9f8
#define ixMCARB_DRAM_TIMING_TABLE_64                                            0x3f9fc
#define ixMCARB_DRAM_TIMING_TABLE_65                                            0x3fa00
#define ixMCARB_DRAM_TIMING_TABLE_66                                            0x3fa04
#define ixMCARB_DRAM_TIMING_TABLE_67                                            0x3fa08
#define ixMCARB_DRAM_TIMING_TABLE_68                                            0x3fa0c
#define ixMCARB_DRAM_TIMING_TABLE_69                                            0x3fa10
#define ixMCARB_DRAM_TIMING_TABLE_70                                            0x3fa14
#define ixMCARB_DRAM_TIMING_TABLE_71                                            0x3fa18
#define ixMCARB_DRAM_TIMING_TABLE_72                                            0x3fa1c
#define ixMCARB_DRAM_TIMING_TABLE_73                                            0x3fa20
#define ixMCARB_DRAM_TIMING_TABLE_74                                            0x3fa24
#define ixMCARB_DRAM_TIMING_TABLE_75                                            0x3fa28
#define ixMCARB_DRAM_TIMING_TABLE_76                                            0x3fa2c
#define ixMCARB_DRAM_TIMING_TABLE_77                                            0x3fa30
#define ixMCARB_DRAM_TIMING_TABLE_78                                            0x3fa34
#define ixMCARB_DRAM_TIMING_TABLE_79                                            0x3fa38
#define ixMCARB_DRAM_TIMING_TABLE_80                                            0x3fa3c
#define ixMCARB_DRAM_TIMING_TABLE_81                                            0x3fa40
#define ixMCARB_DRAM_TIMING_TABLE_82                                            0x3fa44
#define ixMCARB_DRAM_TIMING_TABLE_83                                            0x3fa48
#define ixMCARB_DRAM_TIMING_TABLE_84                                            0x3fa4c
#define ixMCARB_DRAM_TIMING_TABLE_85                                            0x3fa50
#define ixMCARB_DRAM_TIMING_TABLE_86                                            0x3fa54
#define ixMCARB_DRAM_TIMING_TABLE_87                                            0x3fa58
#define ixMCARB_DRAM_TIMING_TABLE_88                                            0x3fa5c
#define ixMCARB_DRAM_TIMING_TABLE_89                                            0x3fa60
#define ixMCARB_DRAM_TIMING_TABLE_90                                            0x3fa64
#define ixMCARB_DRAM_TIMING_TABLE_91                                            0x3fa68
#define ixMCARB_DRAM_TIMING_TABLE_92                                            0x3fa6c
#define ixMCARB_DRAM_TIMING_TABLE_93                                            0x3fa70
#define ixMCARB_DRAM_TIMING_TABLE_94                                            0x3fa74
#define ixMCARB_DRAM_TIMING_TABLE_95                                            0x3fa78
#define ixMCARB_DRAM_TIMING_TABLE_96                                            0x3fa7c
#define ixMC_REGISTERS_TABLE_1                                                  0x3fa80
#define ixMC_REGISTERS_TABLE_2                                                  0x3fa84
#define ixMC_REGISTERS_TABLE_3                                                  0x3fa88
#define ixMC_REGISTERS_TABLE_4                                                  0x3fa8c
#define ixMC_REGISTERS_TABLE_5                                                  0x3fa90
#define ixMC_REGISTERS_TABLE_6                                                  0x3fa94
#define ixMC_REGISTERS_TABLE_7                                                  0x3fa98
#define ixMC_REGISTERS_TABLE_8                                                  0x3fa9c
#define ixMC_REGISTERS_TABLE_9                                                  0x3faa0
#define ixMC_REGISTERS_TABLE_10                                                 0x3faa4
#define ixMC_REGISTERS_TABLE_11                                                 0x3faa8
#define ixMC_REGISTERS_TABLE_12                                                 0x3faac
#define ixMC_REGISTERS_TABLE_13                                                 0x3fab0
#define ixMC_REGISTERS_TABLE_14                                                 0x3fab4
#define ixMC_REGISTERS_TABLE_15                                                 0x3fab8
#define ixMC_REGISTERS_TABLE_16                                                 0x3fabc
#define ixMC_REGISTERS_TABLE_17                                                 0x3fac0
#define ixMC_REGISTERS_TABLE_18                                                 0x3fac4
#define ixMC_REGISTERS_TABLE_19                                                 0x3fac8
#define ixMC_REGISTERS_TABLE_20                                                 0x3facc
#define ixMC_REGISTERS_TABLE_21                                                 0x3fad0
#define ixMC_REGISTERS_TABLE_22                                                 0x3fad4
#define ixMC_REGISTERS_TABLE_23                                                 0x3fad8
#define ixMC_REGISTERS_TABLE_24                                                 0x3fadc
#define ixMC_REGISTERS_TABLE_25                                                 0x3fae0
#define ixMC_REGISTERS_TABLE_26                                                 0x3fae4
#define ixMC_REGISTERS_TABLE_27                                                 0x3fae8
#define ixMC_REGISTERS_TABLE_28                                                 0x3faec
#define ixMC_REGISTERS_TABLE_29                                                 0x3faf0
#define ixMC_REGISTERS_TABLE_30                                                 0x3faf4
#define ixMC_REGISTERS_TABLE_31                                                 0x3faf8
#define ixMC_REGISTERS_TABLE_32                                                 0x3fafc
#define ixMC_REGISTERS_TABLE_33                                                 0x3fb00
#define ixMC_REGISTERS_TABLE_34                                                 0x3fb04
#define ixMC_REGISTERS_TABLE_35                                                 0x3fb08
#define ixMC_REGISTERS_TABLE_36                                                 0x3fb0c
#define ixMC_REGISTERS_TABLE_37                                                 0x3fb10
#define ixMC_REGISTERS_TABLE_38                                                 0x3fb14
#define ixMC_REGISTERS_TABLE_39                                                 0x3fb18
#define ixMC_REGISTERS_TABLE_40                                                 0x3fb1c
#define ixMC_REGISTERS_TABLE_41                                                 0x3fb20
#define ixMC_REGISTERS_TABLE_42                                                 0x3fb24
#define ixMC_REGISTERS_TABLE_43                                                 0x3fb28
#define ixMC_REGISTERS_TABLE_44                                                 0x3fb2c
#define ixMC_REGISTERS_TABLE_45                                                 0x3fb30
#define ixMC_REGISTERS_TABLE_46                                                 0x3fb34
#define ixMC_REGISTERS_TABLE_47                                                 0x3fb38
#define ixMC_REGISTERS_TABLE_48                                                 0x3fb3c
#define ixMC_REGISTERS_TABLE_49                                                 0x3fb40
#define ixMC_REGISTERS_TABLE_50                                                 0x3fb44
#define ixMC_REGISTERS_TABLE_51                                                 0x3fb48
#define ixMC_REGISTERS_TABLE_52                                                 0x3fb4c
#define ixMC_REGISTERS_TABLE_53                                                 0x3fb50
#define ixMC_REGISTERS_TABLE_54                                                 0x3fb54
#define ixMC_REGISTERS_TABLE_55                                                 0x3fb58
#define ixMC_REGISTERS_TABLE_56                                                 0x3fb5c
#define ixMC_REGISTERS_TABLE_57                                                 0x3fb60
#define ixMC_REGISTERS_TABLE_58                                                 0x3fb64
#define ixMC_REGISTERS_TABLE_59                                                 0x3fb68
#define ixMC_REGISTERS_TABLE_60                                                 0x3fb6c
#define ixMC_REGISTERS_TABLE_61                                                 0x3fb70
#define ixMC_REGISTERS_TABLE_62                                                 0x3fb74
#define ixMC_REGISTERS_TABLE_63                                                 0x3fb78
#define ixMC_REGISTERS_TABLE_64                                                 0x3fb7c
#define ixMC_REGISTERS_TABLE_65                                                 0x3fb80
#define ixMC_REGISTERS_TABLE_66                                                 0x3fb84
#define ixMC_REGISTERS_TABLE_67                                                 0x3fb88
#define ixMC_REGISTERS_TABLE_68                                                 0x3fb8c
#define ixMC_REGISTERS_TABLE_69                                                 0x3fb90
#define ixMC_REGISTERS_TABLE_70                                                 0x3fb94
#define ixMC_REGISTERS_TABLE_71                                                 0x3fb98
#define ixMC_REGISTERS_TABLE_72                                                 0x3fb9c
#define ixMC_REGISTERS_TABLE_73                                                 0x3fba0
#define ixMC_REGISTERS_TABLE_74                                                 0x3fba4
#define ixMC_REGISTERS_TABLE_75                                                 0x3fba8
#define ixMC_REGISTERS_TABLE_76                                                 0x3fbac
#define ixMC_REGISTERS_TABLE_77                                                 0x3fbb0
#define ixMC_REGISTERS_TABLE_78                                                 0x3fbb4
#define ixMC_REGISTERS_TABLE_79                                                 0x3fbb8
#define ixMC_REGISTERS_TABLE_80                                                 0x3fbbc
#define ixMC_REGISTERS_TABLE_81                                                 0x3fbc0
#define ixFAN_TABLE_1                                                           0x3fbc4
#define ixFAN_TABLE_2                                                           0x3fbc8
#define ixFAN_TABLE_3                                                           0x3fbcc
#define ixFAN_TABLE_4                                                           0x3fbd0
#define ixFAN_TABLE_5                                                           0x3fbd4
#define ixFAN_TABLE_6                                                           0x3fbd8
#define ixFAN_TABLE_7                                                           0x3fbdc
#define ixFAN_TABLE_8                                                           0x3fbe0
#define ixFAN_TABLE_9                                                           0x3fbe4
#define ixSOFT_REGISTERS_TABLE_1                                                0x3fbe8
#define ixSOFT_REGISTERS_TABLE_2                                                0x3fbec
#define ixSOFT_REGISTERS_TABLE_3                                                0x3fbf0
#define ixSOFT_REGISTERS_TABLE_4                                                0x3fbf4
#define ixSOFT_REGISTERS_TABLE_5                                                0x3fbf8
#define ixSOFT_REGISTERS_TABLE_6                                                0x3fbfc
#define ixSOFT_REGISTERS_TABLE_7                                                0x3fc00
#define ixSOFT_REGISTERS_TABLE_8                                                0x3fc04
#define ixSOFT_REGISTERS_TABLE_9                                                0x3fc08
#define ixSOFT_REGISTERS_TABLE_10                                               0x3fc0c
#define ixSOFT_REGISTERS_TABLE_11                                               0x3fc10
#define ixSOFT_REGISTERS_TABLE_12                                               0x3fc14
#define ixSOFT_REGISTERS_TABLE_13                                               0x3fc18
#define ixSOFT_REGISTERS_TABLE_14                                               0x3fc1c
#define ixSOFT_REGISTERS_TABLE_15                                               0x3fc20
#define ixSOFT_REGISTERS_TABLE_16                                               0x3fc24
#define ixSOFT_REGISTERS_TABLE_17                                               0x3fc28
#define ixSOFT_REGISTERS_TABLE_18                                               0x3fc2c
#define ixSOFT_REGISTERS_TABLE_19                                               0x3fc30
#define ixSOFT_REGISTERS_TABLE_20                                               0x3fc34
#define ixSOFT_REGISTERS_TABLE_21                                               0x3fc38
#define ixSOFT_REGISTERS_TABLE_22                                               0x3fc3c
#define ixSOFT_REGISTERS_TABLE_23                                               0x3fc40
#define ixSOFT_REGISTERS_TABLE_24                                               0x3fc44
#define ixSOFT_REGISTERS_TABLE_25                                               0x3fc48
#define ixSOFT_REGISTERS_TABLE_26                                               0x3fc4c
#define ixSOFT_REGISTERS_TABLE_27                                               0x3fc50
#define ixSOFT_REGISTERS_TABLE_28                                               0x3fc54
#define ixSOFT_REGISTERS_TABLE_29                                               0x3fc58
#define ixSOFT_REGISTERS_TABLE_30                                               0x3fc5c
#define ixPM_FUSES_1                                                            0x3fc60
#define ixPM_FUSES_2                                                            0x3fc64
#define ixPM_FUSES_3                                                            0x3fc68
#define ixPM_FUSES_4                                                            0x3fc6c
#define ixPM_FUSES_5                                                            0x3fc70
#define ixPM_FUSES_6                                                            0x3fc74
#define ixPM_FUSES_7                                                            0x3fc78
#define ixPM_FUSES_8                                                            0x3fc7c
#define ixPM_FUSES_9                                                            0x3fc80
#define ixPM_FUSES_10                                                           0x3fc84
#define ixPM_FUSES_11                                                           0x3fc88
#define ixPM_FUSES_12                                                           0x3fc8c
#define ixPM_FUSES_13                                                           0x3fc90
#define ixPM_FUSES_14                                                           0x3fc94
#define ixPM_FUSES_15                                                           0x3fc98
#define ixSMU_PM_STATUS_0                                                       0x3fe00
#define ixSMU_PM_STATUS_1                                                       0x3fe04
#define ixSMU_PM_STATUS_2                                                       0x3fe08
#define ixSMU_PM_STATUS_3                                                       0x3fe0c
#define ixSMU_PM_STATUS_4                                                       0x3fe10
#define ixSMU_PM_STATUS_5                                                       0x3fe14
#define ixSMU_PM_STATUS_6                                                       0x3fe18
#define ixSMU_PM_STATUS_7                                                       0x3fe1c
#define ixSMU_PM_STATUS_8                                                       0x3fe20
#define ixSMU_PM_STATUS_9                                                       0x3fe24
#define ixSMU_PM_STATUS_10                                                      0x3fe28
#define ixSMU_PM_STATUS_11                                                      0x3fe2c
#define ixSMU_PM_STATUS_12                                                      0x3fe30
#define ixSMU_PM_STATUS_13                                                      0x3fe34
#define ixSMU_PM_STATUS_14                                                      0x3fe38
#define ixSMU_PM_STATUS_15                                                      0x3fe3c
#define ixSMU_PM_STATUS_16                                                      0x3fe40
#define ixSMU_PM_STATUS_17                                                      0x3fe44
#define ixSMU_PM_STATUS_18                                                      0x3fe48
#define ixSMU_PM_STATUS_19                                                      0x3fe4c
#define ixSMU_PM_STATUS_20                                                      0x3fe50
#define ixSMU_PM_STATUS_21                                                      0x3fe54
#define ixSMU_PM_STATUS_22                                                      0x3fe58
#define ixSMU_PM_STATUS_23                                                      0x3fe5c
#define ixSMU_PM_STATUS_24                                                      0x3fe60
#define ixSMU_PM_STATUS_25                                                      0x3fe64
#define ixSMU_PM_STATUS_26                                                      0x3fe68
#define ixSMU_PM_STATUS_27                                                      0x3fe6c
#define ixSMU_PM_STATUS_28                                                      0x3fe70
#define ixSMU_PM_STATUS_29                                                      0x3fe74
#define ixSMU_PM_STATUS_30                                                      0x3fe78
#define ixSMU_PM_STATUS_31                                                      0x3fe7c
#define ixSMU_PM_STATUS_32                                                      0x3fe80
#define ixSMU_PM_STATUS_33                                                      0x3fe84
#define ixSMU_PM_STATUS_34                                                      0x3fe88
#define ixSMU_PM_STATUS_35                                                      0x3fe8c
#define ixSMU_PM_STATUS_36                                                      0x3fe90
#define ixSMU_PM_STATUS_37                                                      0x3fe94
#define ixSMU_PM_STATUS_38                                                      0x3fe98
#define ixSMU_PM_STATUS_39                                                      0x3fe9c
#define ixSMU_PM_STATUS_40                                                      0x3fea0
#define ixSMU_PM_STATUS_41                                                      0x3fea4
#define ixSMU_PM_STATUS_42                                                      0x3fea8
#define ixSMU_PM_STATUS_43                                                      0x3feac
#define ixSMU_PM_STATUS_44                                                      0x3feb0
#define ixSMU_PM_STATUS_45                                                      0x3feb4
#define ixSMU_PM_STATUS_46                                                      0x3feb8
#define ixSMU_PM_STATUS_47                                                      0x3febc
#define ixSMU_PM_STATUS_48                                                      0x3fec0
#define ixSMU_PM_STATUS_49                                                      0x3fec4
#define ixSMU_PM_STATUS_50                                                      0x3fec8
#define ixSMU_PM_STATUS_51                                                      0x3fecc
#define ixSMU_PM_STATUS_52                                                      0x3fed0
#define ixSMU_PM_STATUS_53                                                      0x3fed4
#define ixSMU_PM_STATUS_54                                                      0x3fed8
#define ixSMU_PM_STATUS_55                                                      0x3fedc
#define ixSMU_PM_STATUS_56                                                      0x3fee0
#define ixSMU_PM_STATUS_57                                                      0x3fee4
#define ixSMU_PM_STATUS_58                                                      0x3fee8
#define ixSMU_PM_STATUS_59                                                      0x3feec
#define ixSMU_PM_STATUS_60                                                      0x3fef0
#define ixSMU_PM_STATUS_61                                                      0x3fef4
#define ixSMU_PM_STATUS_62                                                      0x3fef8
#define ixSMU_PM_STATUS_63                                                      0x3fefc
#define ixSMU_PM_STATUS_64                                                      0x3ff00
#define ixSMU_PM_STATUS_65                                                      0x3ff04
#define ixSMU_PM_STATUS_66                                                      0x3ff08
#define ixSMU_PM_STATUS_67                                                      0x3ff0c
#define ixSMU_PM_STATUS_68                                                      0x3ff10
#define ixSMU_PM_STATUS_69                                                      0x3ff14
#define ixSMU_PM_STATUS_70                                                      0x3ff18
#define ixSMU_PM_STATUS_71                                                      0x3ff1c
#define ixSMU_PM_STATUS_72                                                      0x3ff20
#define ixSMU_PM_STATUS_73                                                      0x3ff24
#define ixSMU_PM_STATUS_74                                                      0x3ff28
#define ixSMU_PM_STATUS_75                                                      0x3ff2c
#define ixSMU_PM_STATUS_76                                                      0x3ff30
#define ixSMU_PM_STATUS_77                                                      0x3ff34
#define ixSMU_PM_STATUS_78                                                      0x3ff38
#define ixSMU_PM_STATUS_79                                                      0x3ff3c
#define ixSMU_PM_STATUS_80                                                      0x3ff40
#define ixSMU_PM_STATUS_81                                                      0x3ff44
#define ixSMU_PM_STATUS_82                                                      0x3ff48
#define ixSMU_PM_STATUS_83                                                      0x3ff4c
#define ixSMU_PM_STATUS_84                                                      0x3ff50
#define ixSMU_PM_STATUS_85                                                      0x3ff54
#define ixSMU_PM_STATUS_86                                                      0x3ff58
#define ixSMU_PM_STATUS_87                                                      0x3ff5c
#define ixSMU_PM_STATUS_88                                                      0x3ff60
#define ixSMU_PM_STATUS_89                                                      0x3ff64
#define ixSMU_PM_STATUS_90                                                      0x3ff68
#define ixSMU_PM_STATUS_91                                                      0x3ff6c
#define ixSMU_PM_STATUS_92                                                      0x3ff70
#define ixSMU_PM_STATUS_93                                                      0x3ff74
#define ixSMU_PM_STATUS_94                                                      0x3ff78
#define ixSMU_PM_STATUS_95                                                      0x3ff7c
#define ixSMU_PM_STATUS_96                                                      0x3ff80
#define ixSMU_PM_STATUS_97                                                      0x3ff84
#define ixSMU_PM_STATUS_98                                                      0x3ff88
#define ixSMU_PM_STATUS_99                                                      0x3ff8c
#define ixSMU_PM_STATUS_100                                                     0x3ff90
#define ixSMU_PM_STATUS_101                                                     0x3ff94
#define ixSMU_PM_STATUS_102                                                     0x3ff98
#define ixSMU_PM_STATUS_103                                                     0x3ff9c
#define ixSMU_PM_STATUS_104                                                     0x3ffa0
#define ixSMU_PM_STATUS_105                                                     0x3ffa4
#define ixSMU_PM_STATUS_106                                                     0x3ffa8
#define ixSMU_PM_STATUS_107                                                     0x3ffac
#define ixSMU_PM_STATUS_108                                                     0x3ffb0
#define ixSMU_PM_STATUS_109                                                     0x3ffb4
#define ixSMU_PM_STATUS_110                                                     0x3ffb8
#define ixSMU_PM_STATUS_111                                                     0x3ffbc
#define ixSMU_PM_STATUS_112                                                     0x3ffc0
#define ixSMU_PM_STATUS_113                                                     0x3ffc4
#define ixSMU_PM_STATUS_114                                                     0x3ffc8
#define ixSMU_PM_STATUS_115                                                     0x3ffcc
#define ixSMU_PM_STATUS_116                                                     0x3ffd0
#define ixSMU_PM_STATUS_117                                                     0x3ffd4
#define ixSMU_PM_STATUS_118                                                     0x3ffd8
#define ixSMU_PM_STATUS_119                                                     0x3ffdc
#define ixSMU_PM_STATUS_120                                                     0x3ffe0
#define ixSMU_PM_STATUS_121                                                     0x3ffe4
#define ixSMU_PM_STATUS_122                                                     0x3ffe8
#define ixSMU_PM_STATUS_123                                                     0x3ffec
#define ixSMU_PM_STATUS_124                                                     0x3fff0
#define ixSMU_PM_STATUS_125                                                     0x3fff4
#define ixSMU_PM_STATUS_126                                                     0x3fff8
#define ixSMU_PM_STATUS_127                                                     0x3fffc
#define ixCG_THERMAL_INT_ENA                                                    0xc2100024
#define ixCG_THERMAL_INT_CTRL                                                   0xc2100028
#define ixCG_THERMAL_INT_STATUS                                                 0xc210002c
#define ixCG_THERMAL_CTRL                                                       0xc0300004
#define ixCG_THERMAL_STATUS                                                     0xc0300008
#define ixCG_THERMAL_INT                                                        0xc030000c
#define ixCG_MULT_THERMAL_CTRL                                                  0xc0300010
#define ixCG_MULT_THERMAL_STATUS                                                0xc0300014
#define ixCG_FDO_CTRL0                                                          0xc0300064
#define ixCG_FDO_CTRL1                                                          0xc0300068
#define ixCG_FDO_CTRL2                                                          0xc030006c
#define ixCG_TACH_CTRL                                                          0xc0300070
#define ixCG_TACH_STATUS                                                        0xc0300074
#define ixCC_THM_STRAPS0                                                        0xc0300080
#define ixTHM_TMON0_RDIL0_DATA                                                  0xc0300100
#define ixTHM_TMON0_RDIL1_DATA                                                  0xc0300104
#define ixTHM_TMON0_RDIL2_DATA                                                  0xc0300108
#define ixTHM_TMON0_RDIL3_DATA                                                  0xc030010c
#define ixTHM_TMON0_RDIL4_DATA                                                  0xc0300110
#define ixTHM_TMON0_RDIL5_DATA                                                  0xc0300114
#define ixTHM_TMON0_RDIL6_DATA                                                  0xc0300118
#define ixTHM_TMON0_RDIL7_DATA                                                  0xc030011c
#define ixTHM_TMON0_RDIL8_DATA                                                  0xc0300120
#define ixTHM_TMON0_RDIL9_DATA                                                  0xc0300124
#define ixTHM_TMON0_RDIL10_DATA                                                 0xc0300128
#define ixTHM_TMON0_RDIL11_DATA                                                 0xc030012c
#define ixTHM_TMON0_RDIL12_DATA                                                 0xc0300130
#define ixTHM_TMON0_RDIL13_DATA                                                 0xc0300134
#define ixTHM_TMON0_RDIL14_DATA                                                 0xc0300138
#define ixTHM_TMON0_RDIL15_DATA                                                 0xc030013c
#define ixTHM_TMON0_RDIR0_DATA                                                  0xc0300140
#define ixTHM_TMON0_RDIR1_DATA                                                  0xc0300144
#define ixTHM_TMON0_RDIR2_DATA                                                  0xc0300148
#define ixTHM_TMON0_RDIR3_DATA                                                  0xc030014c
#define ixTHM_TMON0_RDIR4_DATA                                                  0xc0300150
#define ixTHM_TMON0_RDIR5_DATA                                                  0xc0300154
#define ixTHM_TMON0_RDIR6_DATA                                                  0xc0300158
#define ixTHM_TMON0_RDIR7_DATA                                                  0xc030015c
#define ixTHM_TMON0_RDIR8_DATA                                                  0xc0300160
#define ixTHM_TMON0_RDIR9_DATA                                                  0xc0300164
#define ixTHM_TMON0_RDIR10_DATA                                                 0xc0300168
#define ixTHM_TMON0_RDIR11_DATA                                                 0xc030016c
#define ixTHM_TMON0_RDIR12_DATA                                                 0xc0300170
#define ixTHM_TMON0_RDIR13_DATA                                                 0xc0300174
#define ixTHM_TMON0_RDIR14_DATA                                                 0xc0300178
#define ixTHM_TMON0_RDIR15_DATA                                                 0xc030017c
#define ixTHM_TMON1_RDIL0_DATA                                                  0xc0300180
#define ixTHM_TMON1_RDIL1_DATA                                                  0xc0300184
#define ixTHM_TMON1_RDIL2_DATA                                                  0xc0300188
#define ixTHM_TMON1_RDIL3_DATA                                                  0xc030018c
#define ixTHM_TMON1_RDIL4_DATA                                                  0xc0300190
#define ixTHM_TMON1_RDIL5_DATA                                                  0xc0300194
#define ixTHM_TMON1_RDIL6_DATA                                                  0xc0300198
#define ixTHM_TMON1_RDIL7_DATA                                                  0xc030019c
#define ixTHM_TMON1_RDIL8_DATA                                                  0xc03001a0
#define ixTHM_TMON1_RDIL9_DATA                                                  0xc03001a4
#define ixTHM_TMON1_RDIL10_DATA                                                 0xc03001a8
#define ixTHM_TMON1_RDIL11_DATA                                                 0xc03001ac
#define ixTHM_TMON1_RDIL12_DATA                                                 0xc03001b0
#define ixTHM_TMON1_RDIL13_DATA                                                 0xc03001b4
#define ixTHM_TMON1_RDIL14_DATA                                                 0xc03001b8
#define ixTHM_TMON1_RDIL15_DATA                                                 0xc03001bc
#define ixTHM_TMON1_RDIR0_DATA                                                  0xc03001c0
#define ixTHM_TMON1_RDIR1_DATA                                                  0xc03001c4
#define ixTHM_TMON1_RDIR2_DATA                                                  0xc03001c8
#define ixTHM_TMON1_RDIR3_DATA                                                  0xc03001cc
#define ixTHM_TMON1_RDIR4_DATA                                                  0xc03001d0
#define ixTHM_TMON1_RDIR5_DATA                                                  0xc03001d4
#define ixTHM_TMON1_RDIR6_DATA                                                  0xc03001d8
#define ixTHM_TMON1_RDIR7_DATA                                                  0xc03001dc
#define ixTHM_TMON1_RDIR8_DATA                                                  0xc03001e0
#define ixTHM_TMON1_RDIR9_DATA                                                  0xc03001e4
#define ixTHM_TMON1_RDIR10_DATA                                                 0xc03001e8
#define ixTHM_TMON1_RDIR11_DATA                                                 0xc03001ec
#define ixTHM_TMON1_RDIR12_DATA                                                 0xc03001f0
#define ixTHM_TMON1_RDIR13_DATA                                                 0xc03001f4
#define ixTHM_TMON1_RDIR14_DATA                                                 0xc03001f8
#define ixTHM_TMON1_RDIR15_DATA                                                 0xc03001fc
#define ixTHM_TMON0_INT_DATA                                                    0xc0300300
#define ixTHM_TMON1_INT_DATA                                                    0xc0300304
#define ixTHM_TMON0_DEBUG                                                       0xc0300310
#define ixTHM_TMON1_DEBUG                                                       0xc0300314
#define ixTHM_TMON0_STATUS                                                      0xc0300320
#define ixTHM_TMON1_STATUS                                                      0xc0300324
#define ixGENERAL_PWRMGT                                                        0xc0200000
#define ixCNB_PWRMGT_CNTL                                                       0xc0200004
#define ixSCLK_PWRMGT_CNTL                                                      0xc0200008
#define ixTARGET_AND_CURRENT_PROFILE_INDEX                                      0xc0200014
#define ixPWR_PCC_CONTROL                                                       0xc0200018
#define ixPWR_PCC_GPIO_SELECT                                                   0xc020001c
#define ixCG_FREQ_TRAN_VOTING_0                                                 0xc02001a8
#define ixCG_FREQ_TRAN_VOTING_1                                                 0xc02001ac
#define ixCG_FREQ_TRAN_VOTING_2                                                 0xc02001b0
#define ixCG_FREQ_TRAN_VOTING_3                                                 0xc02001b4
#define ixCG_FREQ_TRAN_VOTING_4                                                 0xc02001b8
#define ixCG_FREQ_TRAN_VOTING_5                                                 0xc02001bc
#define ixCG_FREQ_TRAN_VOTING_6                                                 0xc02001c0
#define ixCG_FREQ_TRAN_VOTING_7                                                 0xc02001c4
#define ixPLL_TEST_CNTL                                                         0xc020003c
#define ixCG_STATIC_SCREEN_PARAMETER                                            0xc0200044
#define ixCG_DISPLAY_GAP_CNTL                                                   0xc0200060
#define ixCG_DISPLAY_GAP_CNTL2                                                  0xc0200230
#define ixCG_ACPI_CNTL                                                          0xc0200064
#define ixSCLK_DEEP_SLEEP_CNTL                                                  0xc0200080
#define ixSCLK_DEEP_SLEEP_CNTL2                                                 0xc0200084
#define ixSCLK_DEEP_SLEEP_CNTL3                                                 0xc020009c
#define ixSCLK_DEEP_SLEEP_MISC_CNTL                                             0xc0200088
#define ixLCLK_DEEP_SLEEP_CNTL                                                  0xc020008c
#define ixLCLK_DEEP_SLEEP_CNTL2                                                 0xc0200310
#define ixTARGET_AND_CURRENT_PROFILE_INDEX_1                                    0xc02000f0
#define ixCG_ULV_PARAMETER                                                      0xc020015c
#define ixSCLK_MIN_DIV                                                          0xc02003ac
#define ixPWR_CKS_ENABLE                                                        0xc020034c
#define ixPWR_CKS_CNTL                                                          0xc0200350
#define ixPWR_DISP_TIMER_CONTROL                                                0xc02003c0
#define ixPWR_DISP_TIMER_DEBUG                                                  0xc02003c4
#define ixPWR_DISP_TIMER2_CONTROL                                               0xc02003c8
#define ixPWR_DISP_TIMER2_DEBUG                                                 0xc02003cc
#define ixPWR_DISP_TIMER_CONTROL2                                               0xc0200378
#define ixVDDGFX_IDLE_PARAMETER                                                 0xc020036c
#define ixVDDGFX_IDLE_CONTROL                                                   0xc0200370
#define ixVDDGFX_IDLE_EXIT                                                      0xc0200374
#define ixLCAC_MC0_CNTL                                                         0xc0400130
#define ixLCAC_MC0_OVR_SEL                                                      0xc0400134
#define ixLCAC_MC0_OVR_VAL                                                      0xc0400138
#define ixLCAC_MC1_CNTL                                                         0xc040013c
#define ixLCAC_MC1_OVR_SEL                                                      0xc0400140
#define ixLCAC_MC1_OVR_VAL                                                      0xc0400144
#define ixLCAC_MC2_CNTL                                                         0xc0400148
#define ixLCAC_MC2_OVR_SEL                                                      0xc040014c
#define ixLCAC_MC2_OVR_VAL                                                      0xc0400150
#define ixLCAC_MC3_CNTL                                                         0xc0400154
#define ixLCAC_MC3_OVR_SEL                                                      0xc0400158
#define ixLCAC_MC3_OVR_VAL                                                      0xc040015c
#define ixLCAC_CPL_CNTL                                                         0xc0400160
#define ixLCAC_CPL_OVR_SEL                                                      0xc0400164
#define ixLCAC_CPL_OVR_VAL                                                      0xc0400168
#define mmROM_SMC_IND_INDEX                                                     0x80
#define mmROM0_ROM_SMC_IND_INDEX                                                0x80
#define mmROM1_ROM_SMC_IND_INDEX                                                0x82
#define mmROM2_ROM_SMC_IND_INDEX                                                0x84
#define mmROM3_ROM_SMC_IND_INDEX                                                0x86
#define mmROM_SMC_IND_DATA                                                      0x81
#define mmROM0_ROM_SMC_IND_DATA                                                 0x81
#define mmROM1_ROM_SMC_IND_DATA                                                 0x83
#define mmROM2_ROM_SMC_IND_DATA                                                 0x85
#define mmROM3_ROM_SMC_IND_DATA                                                 0x87
#define ixROM_CNTL                                                              0xc0600000
#define ixPAGE_MIRROR_CNTL                                                      0xc0600004
#define ixROM_STATUS                                                            0xc0600008
#define ixCGTT_ROM_CLK_CTRL0                                                    0xc060000c
#define ixROM_INDEX                                                             0xc0600010
#define ixROM_DATA                                                              0xc0600014
#define ixROM_START                                                             0xc0600018
#define ixROM_SW_CNTL                                                           0xc060001c
#define ixROM_SW_STATUS                                                         0xc0600020
#define ixROM_SW_COMMAND                                                        0xc0600024
#define ixROM_SW_DATA_1                                                         0xc0600028
#define ixROM_SW_DATA_2                                                         0xc060002c
#define ixROM_SW_DATA_3                                                         0xc0600030
#define ixROM_SW_DATA_4                                                         0xc0600034
#define ixROM_SW_DATA_5                                                         0xc0600038
#define ixROM_SW_DATA_6                                                         0xc060003c
#define ixROM_SW_DATA_7                                                         0xc0600040
#define ixROM_SW_DATA_8                                                         0xc0600044
#define ixROM_SW_DATA_9                                                         0xc0600048
#define ixROM_SW_DATA_10                                                        0xc060004c
#define ixROM_SW_DATA_11                                                        0xc0600050
#define ixROM_SW_DATA_12                                                        0xc0600054
#define ixROM_SW_DATA_13                                                        0xc0600058
#define ixROM_SW_DATA_14                                                        0xc060005c
#define ixROM_SW_DATA_15                                                        0xc0600060
#define ixROM_SW_DATA_16                                                        0xc0600064
#define ixROM_SW_DATA_17                                                        0xc0600068
#define ixROM_SW_DATA_18                                                        0xc060006c
#define ixROM_SW_DATA_19                                                        0xc0600070
#define ixROM_SW_DATA_20                                                        0xc0600074
#define ixROM_SW_DATA_21                                                        0xc0600078
#define ixROM_SW_DATA_22                                                        0xc060007c
#define ixROM_SW_DATA_23                                                        0xc0600080
#define ixROM_SW_DATA_24                                                        0xc0600084
#define ixROM_SW_DATA_25                                                        0xc0600088
#define ixROM_SW_DATA_26                                                        0xc060008c
#define ixROM_SW_DATA_27                                                        0xc0600090
#define ixROM_SW_DATA_28                                                        0xc0600094
#define ixROM_SW_DATA_29                                                        0xc0600098
#define ixROM_SW_DATA_30                                                        0xc060009c
#define ixROM_SW_DATA_31                                                        0xc06000a0
#define ixROM_SW_DATA_32                                                        0xc06000a4
#define ixROM_SW_DATA_33                                                        0xc06000a8
#define ixROM_SW_DATA_34                                                        0xc06000ac
#define ixROM_SW_DATA_35                                                        0xc06000b0
#define ixROM_SW_DATA_36                                                        0xc06000b4
#define ixROM_SW_DATA_37                                                        0xc06000b8
#define ixROM_SW_DATA_38                                                        0xc06000bc
#define ixROM_SW_DATA_39                                                        0xc06000c0
#define ixROM_SW_DATA_40                                                        0xc06000c4
#define ixROM_SW_DATA_41                                                        0xc06000c8
#define ixROM_SW_DATA_42                                                        0xc06000cc
#define ixROM_SW_DATA_43                                                        0xc06000d0
#define ixROM_SW_DATA_44                                                        0xc06000d4
#define ixROM_SW_DATA_45                                                        0xc06000d8
#define ixROM_SW_DATA_46                                                        0xc06000dc
#define ixROM_SW_DATA_47                                                        0xc06000e0
#define ixROM_SW_DATA_48                                                        0xc06000e4
#define ixROM_SW_DATA_49                                                        0xc06000e8
#define ixROM_SW_DATA_50                                                        0xc06000ec
#define ixROM_SW_DATA_51                                                        0xc06000f0
#define ixROM_SW_DATA_52                                                        0xc06000f4
#define ixROM_SW_DATA_53                                                        0xc06000f8
#define ixROM_SW_DATA_54                                                        0xc06000fc
#define ixROM_SW_DATA_55                                                        0xc0600100
#define ixROM_SW_DATA_56                                                        0xc0600104
#define ixROM_SW_DATA_57                                                        0xc0600108
#define ixROM_SW_DATA_58                                                        0xc060010c
#define ixROM_SW_DATA_59                                                        0xc0600110
#define ixROM_SW_DATA_60                                                        0xc0600114
#define ixROM_SW_DATA_61                                                        0xc0600118
#define ixROM_SW_DATA_62                                                        0xc060011c
#define ixROM_SW_DATA_63                                                        0xc0600120
#define ixROM_SW_DATA_64                                                        0xc0600124

#endif /* SMU_7_1_2_D_H */
